set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9427015';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-8-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '22402320',
      58.384318,
      15.973009,
      '0120222',
      4,
      2,
      2,
      2,
      '311414',
      0,
      NULL,
      25.692764,
      26.739001,
      1.182575,
      NULL,
      NULL,
      0.858072,
      2.883316,
      1.280396,
      1.951768,
      3.048145,
      1.564604,
      NULL,
      0.943926,
      NULL,
      1,
      1,
      0,
      0.398141,
      0.731100,
      0,
      5.852216,
      1.718541,
      1,
      0,
      1,
      1.188390,
      4.260248,
      0,
      0.074719,
      1.772361,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.907667,
      0.295904,
      0.243672,
      1,
      1,
      1,
      0.950065,
      0.355961,
      1.338730,
      1.504509,
      0.200731,
      NULL,
      1,
      NULL,
      0,
      0,
      3.141577,
      NULL,
      0,
      1.145814,
      3.525660,
      0.620477,
      3.755104,
      NULL,
      2,
      1,
      0.181453,
      NULL,
      NULL,
      1.620514,
      NULL,
      NULL,
      1.177139,
      3.983155,
      4.046601,
      4.073836,
      5,
      1,
      1.106002,
      1.573256,
      1.111273,
      NULL,
      0.083098,
      0.515500,
      0,
      0.358404,
      0.853502,
      NULL,
      NULL,
      1.912811,
      0,
      NULL,
      NULL,
      0,
      0.865265,
      0,
      1.056731,
      0,
      1.000507,
      1.298222,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      3,
      NULL,
      1,
      NULL,
      6.560374,
      0.227503,
      2.917789,
      NULL,
      1,
      0.108211,
      2,
      1.944476,
      0.454916,
      6,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.369127,
      NULL,
      NULL,
      1,
      3,
      1.676211,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.252010,
      3.737769,
      0,
      1.342099,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.147373,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.751910,
      1,
      NULL,
      1,
      0.890819,
      1,
      1,
      1.382513,
      0,
      1.885603,
      1,
      1,
      1.011103,
      0.364090,
      NULL,
      NULL,
      0.587878,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.808051,
      '11340',
      '24103',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      4.114589,
      6.476269,
      2,
      NULL,
      1,
      NULL,
      2.918617,
      0,
      1);
commit;
end;
/


