set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9427015';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-2-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4331',
      '10423243',
      62.617493,
      10,
      '1230142',
      25.257435,
      4,
      2.898703,
      NULL,
      NULL,
      1.727957,
      NULL,
      22.324889,
      59,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.695017,
      0.009406,
      1,
      2.128701,
      1.038580,
      NULL,
      1,
      NULL,
      0.368694,
      0,
      4,
      NULL,
      0.561958,
      0.019737,
      1,
      1,
      1.317603,
      NULL,
      1,
      4.512252,
      1.306934,
      0.757328,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.695701,
      0.247392,
      1,
      1.776172,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      3,
      0,
      0,
      0.315584,
      1.640235,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.057420,
      5.384930,
      7.712227,
      4,
      1.937643,
      NULL,
      0,
      0,
      NULL,
      1,
      1,
      0.372628,
      NULL,
      0.532797,
      0.874013,
      1.107184,
      1,
      0.092015,
      NULL,
      0.633840,
      NULL,
      0.360793,
      0.434717,
      1.306485,
      0,
      0.412286,
      NULL,
      0.148542,
      1.527012,
      0,
      1.517120,
      1,
      NULL,
      0,
      1.563663,
      NULL,
      1,
      2.372227,
      0,
      NULL,
      1.022048,
      0.656096,
      3,
      4,
      NULL,
      0.016473,
      0,
      0,
      1.591978,
      1.675069,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      10.763184,
      NULL,
      1.225380,
      0.254911,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.425113,
      0,
      1,
      0,
      2.014912,
      2,
      1,
      NULL,
      2,
      0.608022,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.981295,
      2,
      1.073144,
      3,
      0.252906,
      NULL,
      0,
      1.652099,
      0.788438,
      NULL,
      1.040281,
      0.692426,
      1.351280,
      0.063839,
      1.164620,
      1.653237,
      NULL,
      0.377618,
      0.972365,
      1.039454,
      1,
      NULL,
      0.289932,
      0,
      0,
      1.385925,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.996242,
      NULL,
      '21413',
      NULL,
      NULL,
      '',
      '',
      '',
      1,
      '',
      '',
      NULL,
      5,
      NULL,
      1.508284,
      3,
      0.630849,
      1,
      2,
      NULL,
      0.002395);
commit;
end;
/


