set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9427015';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-7-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0204',
      NULL,
      39.376325,
      55,
      '1024324',
      33,
      3,
      2,
      1,
      '240242',
      0,
      NULL,
      28.867702,
      53.056904,
      1,
      NULL,
      0,
      1,
      NULL,
      0,
      0.258789,
      1,
      0.243702,
      NULL,
      NULL,
      0,
      1.635850,
      0,
      1,
      1.035489,
      0,
      NULL,
      4,
      1,
      NULL,
      1.073892,
      NULL,
      1,
      5,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      0.176821,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.609053,
      2,
      1,
      0,
      1.399918,
      1.266757,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.544972,
      0,
      2,
      5.641945,
      NULL,
      1.594175,
      1,
      1,
      1.431636,
      1,
      0.256934,
      1.383266,
      1,
      1,
      0.123728,
      1,
      NULL,
      0,
      0.275052,
      NULL,
      NULL,
      0.068838,
      0,
      0.873496,
      1,
      0,
      0,
      NULL,
      NULL,
      1,
      0.243976,
      2.005384,
      0,
      0,
      3,
      0.047236,
      1,
      2.772069,
      0.730399,
      0,
      5,
      0,
      1,
      NULL,
      4,
      0,
      1.155700,
      5.591464,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.520102,
      0,
      0,
      2,
      1.950744,
      NULL,
      2.554878,
      1.565655,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.429694,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.067643,
      1,
      0.191039,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.377177,
      0.316326,
      0.832958,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.503941,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      0.760765,
      0,
      1,
      0.968667,
      NULL,
      NULL,
      1.446325,
      0.929134,
      0,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.143806,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.299739,
      '11043',
      '10140',
      '',
      0,
      '',
      '',
      '',
      1.796071,
      '',
      '',
      '',
      0.187069,
      7.948694,
      1.740481,
      2,
      3,
      2,
      2,
      0,
      2.271282);
commit;
end;
/


