set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9427015';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-1-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1341',
      '22041242',
      84.444212,
      81.429811,
      '2002132',
      43,
      3,
      2.236849,
      2,
      '042220',
      5.527045,
      NULL,
      53,
      47,
      0,
      NULL,
      NULL,
      2.898669,
      1,
      1.830158,
      1.482561,
      0.784863,
      1.017336,
      0.968559,
      0,
      NULL,
      1,
      1.824967,
      1,
      NULL,
      NULL,
      1,
      0.846478,
      1.882060,
      0,
      1,
      NULL,
      1.000415,
      5.164475,
      1,
      NULL,
      2.211503,
      NULL,
      0.748928,
      NULL,
      NULL,
      1.402638,
      NULL,
      NULL,
      2,
      NULL,
      0.394639,
      0.570256,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.027784,
      5,
      NULL,
      2,
      0.342782,
      0.980216,
      NULL,
      NULL,
      0.765298,
      NULL,
      NULL,
      0.599953,
      3.413234,
      5,
      2.050415,
      3,
      1,
      NULL,
      0.649221,
      1.490392,
      0.837769,
      NULL,
      1,
      0.493474,
      0,
      NULL,
      1.699565,
      0.858818,
      0,
      1.491213,
      NULL,
      1,
      0,
      0.834137,
      0.201306,
      1.474974,
      0.963594,
      0,
      0.289198,
      0.596683,
      0.291834,
      1,
      0.780824,
      0,
      0.195964,
      2,
      0,
      4.408416,
      1,
      1.807372,
      5,
      NULL,
      2,
      NULL,
      3.683800,
      1.830914,
      5.159435,
      0.786116,
      4.160345,
      0.322120,
      NULL,
      NULL,
      7,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      1.745448,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.701636,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.568453,
      0.741027,
      0.143285,
      5,
      3,
      1,
      1.607306,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.339716,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.132164,
      2,
      0,
      NULL,
      3,
      0,
      0,
      3.394311,
      1.489426,
      2,
      NULL,
      1,
      0.368192,
      1,
      NULL,
      1,
      0,
      1.925861,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.561362,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      '01112',
      '24314',
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      2,
      5.589855,
      NULL,
      0,
      NULL,
      3.066237,
      2,
      NULL,
      NULL);
commit;
end;
/


