set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9736648';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-9-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '13134441',
      75.422685,
      50,
      '1020312',
      41,
      NULL,
      1.080704,
      1,
      '342441',
      6,
      '11-19-1978',
      38,
      262,
      0.133054,
      NULL,
      1.347440,
      1,
      0.740202,
      1.386867,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      5.578853,
      NULL,
      0.723886,
      0,
      0,
      1,
      5,
      NULL,
      1,
      3.450648,
      3,
      1,
      NULL,
      1,
      5,
      1,
      2.936513,
      0,
      NULL,
      NULL,
      0.112284,
      NULL,
      NULL,
      1,
      0.588210,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.689807,
      1.043156,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.500554,
      1,
      0,
      7,
      3.594628,
      0.946049,
      0,
      0,
      NULL,
      NULL,
      0.737897,
      2.366054,
      NULL,
      1,
      0.191503,
      1,
      1.978777,
      NULL,
      NULL,
      4.554116,
      5,
      NULL,
      3,
      1,
      3.255302,
      NULL,
      0.597489,
      5,
      4.224647,
      1.959154,
      1.611969,
      NULL,
      9,
      0.907083,
      8.718023,
      NULL,
      9.134680,
      NULL,
      3.720477,
      NULL,
      5,
      NULL,
      11,
      NULL,
      NULL,
      2,
      1,
      0.764939,
      0.170120,
      1.731610,
      0.769128,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.087879,
      0.074671,
      1,
      NULL,
      NULL,
      1,
      1,
      1.569173,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.686769,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.664850,
      NULL,
      NULL,
      NULL,
      NULL,
      1.971107,
      1.094640,
      4,
      8,
      NULL,
      0,
      0.122223,
      NULL,
      NULL,
      NULL,
      1,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.416340,
      3.733261,
      0.597673,
      1,
      2.429203,
      2.388787,
      NULL,
      NULL,
      2,
      2,
      0.900525,
      0.123925,
      1,
      1,
      NULL,
      1.769069,
      0,
      0.052366,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.589830,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      '24314',
      NULL,
      NULL,
      0,
      '',
      '',
      NULL,
      0,
      '',
      '',
      '',
      2.364942,
      4,
      NULL,
      NULL,
      1,
      3.821557,
      NULL,
      1,
      2.964423);
commit;
end;
/


