set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9736648';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-3-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0322',
      '13241313',
      34.021818,
      35.952759,
      '4012312',
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      2,
      ' 7- 6-2001',
      182.871089,
      NULL,
      1.683225,
      NULL,
      2.452063,
      1,
      0.669970,
      0,
      2,
      NULL,
      0,
      NULL,
      0,
      0,
      4,
      0.575795,
      1,
      NULL,
      0.508013,
      0.781974,
      3,
      0,
      NULL,
      1,
      NULL,
      0.017627,
      0.884743,
      1,
      3.657213,
      1.548674,
      0.486115,
      NULL,
      NULL,
      NULL,
      0.977275,
      NULL,
      NULL,
      1.572218,
      0,
      1.785442,
      0.056340,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.730845,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.278284,
      0,
      0,
      0.170130,
      NULL,
      1,
      1,
      0,
      0,
      0.943668,
      NULL,
      0.841353,
      0.211640,
      0.889730,
      0.137962,
      1.905090,
      1.693663,
      1,
      1,
      NULL,
      NULL,
      0,
      1.379226,
      NULL,
      3.881287,
      1,
      5,
      NULL,
      3.702245,
      NULL,
      1,
      0,
      1.133554,
      5,
      1,
      0.990072,
      NULL,
      3,
      1,
      2.887972,
      2,
      5,
      4.019060,
      NULL,
      6.089739,
      NULL,
      NULL,
      1.201005,
      NULL,
      NULL,
      NULL,
      5.004795,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.183322,
      1,
      1,
      0,
      0,
      1.078158,
      0,
      0.902033,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.471501,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.786956,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.717288,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      5.342890,
      1.459888,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.460178,
      0,
      1.967632,
      1.343613,
      NULL,
      3.049376,
      0.834028,
      NULL,
      1.187433,
      0.551392,
      1.562814,
      1,
      0,
      1,
      NULL,
      1.388744,
      0.018694,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.675748,
      '34124',
      '',
      '',
      0.390768,
      '',
      NULL,
      NULL,
      0,
      '',
      '',
      '',
      0,
      NULL,
      3.592834,
      5.802524,
      2.407856,
      0,
      0.709459,
      2,
      1.863606);
commit;
end;
/


