set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7622842';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-12-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '413',
      '14',
      16,
      5,
      '3133323',
      3.129231,
      4,
      3.717197,
      2,
      '113401',
      NULL,
      ' 5- 2-2000',
      NULL,
      33,
      1.657044,
      NULL,
      0.213428,
      0,
      1.597702,
      NULL,
      NULL,
      0.503973,
      2.620654,
      NULL,
      1,
      0.412667,
      1.623645,
      0.440010,
      1.431645,
      NULL,
      1.125054,
      0.692200,
      0,
      1.704623,
      0.788496,
      1.277128,
      1.119218,
      1.258753,
      1.812025,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.441420,
      0.063788,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.513702,
      NULL,
      1.351019,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.072882,
      2.813207,
      0,
      2,
      0.981735,
      1,
      1,
      0.325092,
      1.807837,
      1,
      0.019282,
      0.196415,
      0,
      0.035931,
      1.607314,
      0.787653,
      NULL,
      1.163749,
      0.756811,
      0,
      1,
      1,
      NULL,
      1.828759,
      NULL,
      3.126289,
      1,
      1,
      NULL,
      0.575760,
      0,
      5,
      NULL,
      1,
      6.816974,
      NULL,
      7.328130,
      1.522304,
      0.376469,
      6,
      4,
      NULL,
      NULL,
      1.169643,
      3,
      0.100686,
      NULL,
      NULL,
      0,
      1.633209,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      2,
      1.658210,
      0.493663,
      0,
      0.854612,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.507395,
      NULL,
      6.905977,
      1.541418,
      1,
      0,
      0,
      0,
      0,
      NULL,
      1.811478,
      6,
      3.536479,
      0.177083,
      NULL,
      NULL,
      NULL,
      5.231200,
      0,
      0,
      1.180689,
      0,
      2,
      7.161675,
      1.362364,
      NULL,
      NULL,
      NULL,
      2,
      0.628642,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.625333,
      1.344291,
      1,
      NULL,
      3,
      NULL,
      0.176781,
      3.421611,
      2,
      1.667211,
      1,
      NULL,
      0,
      0.908607,
      1,
      0,
      NULL,
      NULL,
      1,
      1.453350,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      '40003',
      NULL,
      '',
      3,
      '41224',
      '',
      '',
      7.950005,
      NULL,
      '4141',
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


