set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7622842';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-3-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '223',
      NULL,
      10,
      10,
      '2204131',
      56.919170,
      1,
      NULL,
      0,
      '211404',
      5,
      ' 5- 0-1985',
      2.101774,
      11.727004,
      NULL,
      NULL,
      3.067127,
      1.262533,
      2.512359,
      0,
      0.558026,
      NULL,
      0.292573,
      1.203369,
      1.865397,
      1.782591,
      2,
      1.330145,
      0.315033,
      1.056623,
      NULL,
      1,
      3,
      0,
      NULL,
      1,
      1,
      1,
      0.858901,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.540159,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.924483,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      0,
      4.589701,
      0,
      NULL,
      0.107047,
      NULL,
      NULL,
      1.999336,
      1.965558,
      NULL,
      1,
      0,
      NULL,
      1.913066,
      0.782081,
      1.722767,
      NULL,
      0.262874,
      0.815458,
      1,
      NULL,
      0.490345,
      1,
      0.146312,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.080030,
      NULL,
      2.535155,
      1,
      1.686306,
      NULL,
      NULL,
      4,
      0.818422,
      3,
      0.014508,
      1.818171,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.353855,
      1.435459,
      2,
      NULL,
      0,
      NULL,
      3.993602,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.659884,
      NULL,
      NULL,
      NULL,
      NULL,
      0.328800,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.801997,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.427806,
      NULL,
      0,
      1.275687,
      5.956862,
      0,
      NULL,
      1.197826,
      NULL,
      NULL,
      NULL,
      1.098376,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.567580,
      0.372165,
      1.038052,
      0.322462,
      0,
      1,
      0,
      0.804074,
      0.331225,
      1,
      1.611985,
      NULL,
      NULL,
      0,
      NULL,
      1.367583,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '12240',
      '2223',
      '',
      2.827717,
      '13422',
      '',
      '',
      6.279819,
      '3311',
      '3033',
      '00032',
      5.670695,
      0.579075,
      NULL,
      2,
      4.723431,
      0,
      NULL,
      5.875135,
      5.797115);
commit;
end;
/


