set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7622842';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-9-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '003',
      '30243031',
      16.286661,
      13,
      NULL,
      79.235403,
      6,
      2.405895,
      NULL,
      '314302',
      4,
      ' 2-18-1980',
      8.013217,
      8.980142,
      0.688494,
      NULL,
      3.293158,
      1,
      2.034676,
      1,
      0.340025,
      0.286743,
      0,
      NULL,
      0.805917,
      0,
      0.286283,
      0.554709,
      NULL,
      2,
      0,
      0,
      6.174494,
      1.161640,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      1.588374,
      NULL,
      NULL,
      0.516520,
      NULL,
      NULL,
      1.793569,
      1.183131,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.898321,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.186433,
      7.784794,
      4,
      1,
      2,
      1.600107,
      1.917024,
      0.793004,
      1.578375,
      1,
      1.750485,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.159529,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.683573,
      1,
      0.659993,
      1.051510,
      NULL,
      3,
      2.686193,
      0,
      0,
      1,
      1,
      2,
      2,
      NULL,
      4,
      5.286027,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      2,
      NULL,
      0.735031,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.431114,
      0,
      NULL,
      0,
      1,
      1,
      1.118866,
      0.915816,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.011374,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.451243,
      1.017587,
      0,
      NULL,
      NULL,
      NULL,
      4,
      1,
      3,
      4.344486,
      NULL,
      0,
      0.318528,
      NULL,
      NULL,
      NULL,
      0.841571,
      1.059383,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      2.459700,
      1.199166,
      1,
      NULL,
      NULL,
      NULL,
      0.417481,
      1.743668,
      0.493752,
      1.811326,
      NULL,
      0.913440,
      1,
      NULL,
      0.617379,
      0.724494,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.964760,
      '00314',
      NULL,
      NULL,
      NULL,
      '20411',
      '',
      '',
      7,
      '1223',
      '0414',
      '40211',
      NULL,
      NULL,
      0.317968,
      3,
      1.841524,
      3.510068,
      3.636010,
      0.625986,
      3);
commit;
end;
/


