set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7622842';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-3-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '004',
      '33021200',
      11.218430,
      27.218170,
      '3344440',
      9,
      0,
      3,
      0,
      '400424',
      0.350623,
      NULL,
      27,
      1,
      0,
      NULL,
      14,
      1.736909,
      3,
      0,
      0,
      1,
      0.323836,
      1,
      1,
      1.336184,
      1.581449,
      1.384288,
      1.143399,
      0.793112,
      0,
      0.460728,
      1,
      0,
      1,
      1.673787,
      0.106117,
      1.130384,
      0.726021,
      NULL,
      3,
      0.258262,
      1.892939,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.784449,
      0.434100,
      1.138027,
      1.636505,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.046032,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      5.019262,
      2,
      0,
      NULL,
      1.441316,
      0,
      1,
      0.471290,
      NULL,
      NULL,
      1.467053,
      1,
      3.966103,
      0.100429,
      NULL,
      1.640504,
      0.307454,
      0,
      NULL,
      0.021587,
      0.394836,
      0,
      1.899363,
      0,
      0,
      0,
      0,
      0,
      NULL,
      1.164246,
      3.365093,
      0.984040,
      1.322384,
      3,
      2,
      5,
      3.235469,
      5,
      3,
      5.121689,
      1.737038,
      5.851370,
      4.236849,
      NULL,
      0,
      0,
      0,
      0.066206,
      NULL,
      0.226716,
      1,
      1.282341,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      2,
      0,
      0.685529,
      1,
      1.729669,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.338427,
      0.475795,
      1.715576,
      NULL,
      NULL,
      NULL,
      1.478464,
      NULL,
      NULL,
      1.803601,
      NULL,
      1,
      1.420280,
      NULL,
      NULL,
      NULL,
      1.564694,
      1.030884,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.021560,
      2.260327,
      2.331062,
      3,
      2,
      1,
      0.508099,
      NULL,
      2.035555,
      1,
      1.641635,
      NULL,
      1.953803,
      0.530948,
      0,
      0,
      NULL,
      1.331700,
      NULL,
      1.830019,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      '13214',
      '3442',
      '',
      0,
      '22120',
      '',
      '',
      1,
      '1130',
      '0133',
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      4.384171,
      2.444870,
      0.838048,
      1.258440);
commit;
end;
/


