set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7622842';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-10-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '331',
      '22204120',
      NULL,
      26.042244,
      '0444231',
      127,
      2,
      NULL,
      2,
      '330143',
      4.792275,
      NULL,
      7,
      63.762902,
      1.029861,
      NULL,
      1.817192,
      0,
      2.290493,
      0,
      0.316517,
      2.327832,
      1.314542,
      1.208221,
      0,
      NULL,
      1,
      1.378014,
      1,
      1,
      1.734785,
      1,
      4,
      0,
      4.126165,
      1.642088,
      1.217994,
      NULL,
      5,
      1,
      1.906376,
      1.386198,
      1,
      0,
      NULL,
      NULL,
      1.709106,
      NULL,
      NULL,
      0.816969,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.346980,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.773542,
      2,
      NULL,
      NULL,
      2.096863,
      NULL,
      NULL,
      1.323215,
      NULL,
      5,
      1.894046,
      1.832223,
      0,
      2.981571,
      NULL,
      1,
      NULL,
      1.351580,
      0.522163,
      NULL,
      0.470972,
      1,
      1.672597,
      1.857206,
      0,
      0,
      1,
      0,
      NULL,
      0.334894,
      NULL,
      1.416229,
      NULL,
      1.449126,
      1,
      0,
      NULL,
      7.483894,
      4.909411,
      1.332770,
      NULL,
      1.244735,
      6.889158,
      2.660830,
      0.084952,
      NULL,
      0.050711,
      3,
      2,
      1.484057,
      1,
      2.530419,
      0.849787,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.614069,
      NULL,
      NULL,
      1,
      0.269977,
      1.530523,
      5.114419,
      0.739743,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.861847,
      NULL,
      2.307149,
      2,
      0.525090,
      0.309272,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.929483,
      NULL,
      0.104086,
      NULL,
      NULL,
      NULL,
      0.539690,
      1.766156,
      6,
      7.484986,
      4,
      0,
      3.687459,
      1.042268,
      NULL,
      NULL,
      0.968773,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.496004,
      0.758333,
      2.470339,
      NULL,
      3,
      2.438541,
      0,
      0.316858,
      2,
      3,
      0,
      1,
      0.364720,
      NULL,
      1.492506,
      0.247197,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      '',
      1,
      '23230',
      '',
      '',
      4.148618,
      '3104',
      '2130',
      '32302',
      4,
      3,
      1,
      4,
      2,
      1,
      3,
      NULL,
      NULL);
commit;
end;
/


