set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7622842';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-11-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4421',
      '14333002',
      35.417886,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      '014221',
      2.289927,
      '11-23-1977',
      29.918288,
      15.292433,
      0,
      NULL,
      2,
      1.449762,
      NULL,
      1.360783,
      0.544946,
      NULL,
      0.827086,
      0,
      1,
      1.195454,
      3,
      1,
      1,
      5,
      1.067959,
      1,
      NULL,
      0.104677,
      1.017209,
      NULL,
      NULL,
      0,
      5,
      1,
      0,
      NULL,
      0.789435,
      NULL,
      NULL,
      NULL,
      0.200860,
      NULL,
      NULL,
      1.551418,
      0.257383,
      1.013205,
      0.418700,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.004999,
      5.064025,
      2,
      0.043551,
      0,
      1,
      1.192962,
      0,
      1,
      1,
      0.135917,
      NULL,
      1,
      4,
      0,
      1.204280,
      0.596729,
      0,
      1.545635,
      NULL,
      0,
      1.861805,
      0,
      0,
      1,
      0,
      NULL,
      0,
      NULL,
      1.609340,
      0,
      1,
      NULL,
      NULL,
      1,
      0.731945,
      NULL,
      3,
      0.439323,
      NULL,
      4.786905,
      NULL,
      1.515654,
      NULL,
      NULL,
      0.304768,
      1,
      1,
      1.225306,
      NULL,
      NULL,
      NULL,
      1.931784,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.670777,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.240797,
      NULL,
      NULL,
      NULL,
      3.252191,
      1.407750,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.385339,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      4.996744,
      1,
      5.671237,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.405444,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.595331,
      2.710108,
      0,
      2,
      0,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      0.361747,
      0,
      0,
      1,
      NULL,
      1.507546,
      0.579440,
      1.628364,
      1.909662,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      '13333',
      NULL,
      '',
      1.063778,
      '32112',
      '',
      '',
      NULL,
      '4014',
      '2431',
      '0330',
      5,
      NULL,
      NULL,
      5.646383,
      NULL,
      NULL,
      2.944685,
      NULL,
      2.493914);
commit;
end;
/


