set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8925188';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-11-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '434',
      '10322212',
      38,
      45.618127,
      '4021023',
      117.610312,
      4,
      0.940594,
      3,
      '120111',
      4.758315,
      ' 9- 6-1983',
      58.719041,
      53.758672,
      0.424204,
      NULL,
      0.138041,
      0.235359,
      NULL,
      0.785056,
      1.876212,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.103536,
      1,
      0,
      0,
      1,
      1.555082,
      0,
      NULL,
      NULL,
      1.507116,
      1,
      0,
      0.846907,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.574259,
      0,
      0.574791,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.233892,
      1.970504,
      1.379304,
      1,
      0.190776,
      1,
      0.948492,
      0.316805,
      1,
      NULL,
      1.385579,
      1.564488,
      0.973338,
      NULL,
      1.192540,
      NULL,
      1.580981,
      1,
      NULL,
      0.990569,
      1.040658,
      3,
      1.082797,
      1.534784,
      0,
      2,
      1.994642,
      NULL,
      NULL,
      NULL,
      NULL,
      0.513270,
      1.842556,
      1.921281,
      1,
      NULL,
      NULL,
      NULL,
      1.059911,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      0.088286,
      NULL,
      0.619817,
      NULL,
      NULL,
      2.970437,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      1.612455,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.336362,
      NULL,
      NULL,
      NULL,
      NULL,
      1.429852,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.684768,
      0,
      0.822680,
      1,
      1,
      NULL,
      0.076167,
      0.524687,
      0.227817,
      0,
      1.292558,
      NULL,
      NULL,
      NULL,
      0.613411,
      1.437151,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.874224,
      0,
      0.168102,
      NULL,
      1,
      1,
      1.894778,
      0,
      0.367513,
      1,
      NULL,
      1,
      1.007326,
      NULL,
      0,
      1.081995,
      0,
      0,
      0,
      1.276993,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      '00200',
      NULL,
      '',
      0,
      NULL,
      '',
      '',
      1.225606,
      '',
      '',
      '',
      5.684851,
      NULL,
      2,
      0,
      2,
      0,
      3,
      1,
      NULL);
commit;
end;
/


