set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9607352';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-11-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '33',
      37,
      1,
      '2201324',
      2.211881,
      5,
      0.104326,
      0,
      '421132',
      5,
      NULL,
      16.309794,
      36.918654,
      1.792346,
      NULL,
      2.942759,
      NULL,
      NULL,
      0.486555,
      0.106826,
      NULL,
      0,
      0.467576,
      NULL,
      1,
      1,
      NULL,
      3,
      0,
      NULL,
      NULL,
      1,
      0.035611,
      2,
      1.481448,
      2.139142,
      0,
      5.303912,
      0,
      2.156917,
      2.671304,
      1,
      0.687150,
      NULL,
      NULL,
      0.257739,
      NULL,
      NULL,
      1,
      NULL,
      1.937136,
      3,
      NULL,
      0,
      1.327721,
      0.331722,
      2,
      1,
      3,
      1,
      NULL,
      3,
      NULL,
      2.385137,
      0.493002,
      0.741656,
      3,
      0.294341,
      NULL,
      0,
      2,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0.927264,
      NULL,
      NULL,
      1.520198,
      1.753902,
      0,
      3.559963,
      0.418332,
      1.494437,
      1.869947,
      1.086998,
      1,
      1,
      1.185777,
      NULL,
      1.250697,
      0,
      0,
      1.160946,
      0,
      0,
      1.730271,
      NULL,
      0,
      1,
      NULL,
      0.654058,
      0.258479,
      0,
      0.225168,
      1.094726,
      NULL,
      0.498046,
      1.532480,
      NULL,
      NULL,
      0,
      1.932160,
      1,
      1.594464,
      1,
      5.050808,
      0.849795,
      3.909953,
      0,
      1.238192,
      0.473768,
      4,
      0,
      0,
      1,
      1.647504,
      NULL,
      NULL,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.359606,
      1,
      0,
      1,
      NULL,
      1.852140,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      2,
      2.752348,
      0.572488,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.143164,
      2,
      3,
      2,
      6,
      0.738477,
      NULL,
      NULL,
      0,
      6.204682,
      0.439283,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      0.310682,
      1.877694,
      1,
      NULL,
      0.845393,
      1.686061,
      NULL,
      NULL,
      1.491101,
      0,
      1.351237,
      0.519223,
      1,
      0.007497,
      0.545601,
      0.957324,
      0.136872,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5,
      NULL,
      '33041',
      '',
      0,
      '',
      '',
      NULL,
      0.687983,
      NULL,
      '',
      '',
      5.038559,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


