set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9607352';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-3-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '023',
      '44',
      35.011473,
      14.782791,
      '2442411',
      10,
      4,
      NULL,
      1,
      '042141',
      3.034962,
      NULL,
      16.172896,
      64.736069,
      NULL,
      NULL,
      NULL,
      1.690424,
      0.868450,
      1,
      0.251259,
      3,
      3,
      1.730910,
      1,
      0,
      5.044328,
      1.423147,
      1.464798,
      1.099500,
      0.854949,
      1.833868,
      0,
      0,
      NULL,
      1.391871,
      1,
      NULL,
      0,
      0,
      2,
      1.831544,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1.232937,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.881156,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      0.408550,
      1.979635,
      0,
      0.821658,
      0.939698,
      0.512168,
      0,
      0,
      0.314437,
      NULL,
      0.939776,
      0.770155,
      0,
      NULL,
      0.343757,
      NULL,
      1,
      NULL,
      0.810203,
      1.717149,
      0.277499,
      0.061000,
      0,
      1.903197,
      3.117159,
      0,
      0,
      1,
      NULL,
      NULL,
      0,
      0,
      2.463456,
      NULL,
      6,
      1.762658,
      2.702994,
      6,
      2,
      2.497030,
      4,
      1,
      NULL,
      0.230297,
      0,
      NULL,
      NULL,
      NULL,
      0.467445,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.529726,
      NULL,
      0,
      1,
      0.837733,
      1.756151,
      1.838692,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.375462,
      NULL,
      5.719385,
      0,
      3,
      1.411108,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2.954891,
      1.580419,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      2,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2.791099,
      0.887803,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.960762,
      NULL,
      1.164187,
      0.496937,
      NULL,
      0.274952,
      0.286627,
      1,
      0.697641,
      2.429138,
      0,
      0.899789,
      0.710715,
      NULL,
      0,
      1.644916,
      1.783161,
      0.001923,
      0.461198,
      0.862534,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.050711,
      '43040',
      '',
      NULL,
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      2.017090,
      NULL,
      1,
      2.416999,
      1,
      2,
      3.620272,
      0,
      2.383794);
commit;
end;
/


