set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9607352';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-9-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '044',
      '23201044',
      11.680362,
      6,
      '0231330',
      25.479654,
      5,
      3.709064,
      0,
      '004220',
      1,
      '10-15-1994',
      24,
      NULL,
      1,
      NULL,
      3.481623,
      0.964921,
      0,
      0.840425,
      NULL,
      NULL,
      1.378083,
      1.731872,
      0.956549,
      0.932092,
      2,
      0.509482,
      NULL,
      0.869948,
      0,
      NULL,
      2.994669,
      0.517585,
      1,
      1,
      1.533901,
      0,
      3.811317,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.496149,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.183812,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.375702,
      0,
      0.514031,
      1,
      NULL,
      NULL,
      NULL,
      1.341299,
      0.112149,
      0.427959,
      NULL,
      0.025342,
      0,
      1.034210,
      0.901534,
      0,
      1.225872,
      0,
      1.937900,
      NULL,
      0,
      0,
      NULL,
      0.860783,
      1,
      0.014214,
      1.403248,
      1.369562,
      1.333606,
      1,
      0,
      0.649547,
      1,
      0.765309,
      0,
      NULL,
      0.822303,
      1,
      1,
      0,
      1.001175,
      0.795064,
      0.639551,
      0.756707,
      0,
      1,
      1,
      1,
      0.836631,
      NULL,
      NULL,
      3,
      0.899290,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.136264,
      0,
      NULL,
      0,
      NULL,
      0.677644,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.070780,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.026826,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.967363,
      0.321920,
      0.410817,
      0.292794,
      0,
      1.669287,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.160187,
      NULL,
      1.532047,
      0.024062,
      0.281465,
      1,
      1.009634,
      NULL,
      1,
      1,
      1.320384,
      0,
      1.027195,
      NULL,
      0.955236,
      1.565441,
      NULL,
      1,
      0.946267,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.243446,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      '32304',
      '',
      NULL,
      NULL,
      NULL,
      '',
      '',
      2,
      NULL,
      '',
      '',
      4,
      3.175819,
      1.139242,
      2,
      NULL,
      1,
      0.100034,
      0,
      3.615827);
commit;
end;
/


