set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9649566';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-10-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '313',
      '12341110',
      42,
      NULL,
      NULL,
      9,
      0,
      1,
      0,
      '344143',
      4.336226,
      NULL,
      21.819711,
      19.744606,
      1,
      NULL,
      NULL,
      1.552135,
      3,
      1,
      0,
      1.837061,
      1.870882,
      2.398281,
      1,
      NULL,
      2,
      0.388056,
      1.567078,
      0.058835,
      0,
      0.323118,
      5,
      1.043490,
      1,
      1,
      1.378952,
      1,
      NULL,
      1,
      3,
      1.289732,
      0.788260,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.725126,
      0.999207,
      0,
      4.582878,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.435493,
      1.167967,
      1,
      0.439281,
      0,
      0.071693,
      0,
      0.759551,
      0,
      0,
      0.695589,
      0,
      1.194613,
      NULL,
      1,
      0.083893,
      1.628630,
      1,
      1,
      NULL,
      1.150122,
      3,
      NULL,
      0,
      1,
      1,
      4.143933,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.044191,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.014603,
      9.967393,
      NULL,
      4.758613,
      9.064194,
      5.247774,
      0.190559,
      1.752530,
      1,
      1,
      1,
      1,
      2.578308,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.828993,
      0.200879,
      1,
      0,
      NULL,
      1,
      1.181119,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.368579,
      NULL,
      0.361693,
      NULL,
      NULL,
      0.681988,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.722704,
      3.130671,
      6,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.136399,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.909491,
      0.101249,
      NULL,
      3.587441,
      NULL,
      0.994935,
      NULL,
      0.093613,
      NULL,
      3,
      1,
      0.713062,
      0.183957,
      1,
      0.150533,
      0.079338,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.756713,
      '32130',
      '',
      NULL,
      1.818331,
      NULL,
      '',
      NULL,
      0,
      '',
      '',
      '',
      3,
      5.068939,
      2.732334,
      NULL,
      1,
      1.808841,
      2,
      3.622900,
      1.588881);
commit;
end;
/


