set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9649566';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-3-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '231',
      '13242104',
      24,
      38.013879,
      '4211424',
      35,
      3,
      0,
      3,
      '303441',
      1.715594,
      ' 6- 4-1974',
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      0.010482,
      0.555913,
      1,
      0,
      0,
      3,
      1.502745,
      0,
      2.198097,
      1,
      0,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      1.944140,
      0.708221,
      1,
      0,
      NULL,
      NULL,
      2.428572,
      0.195529,
      NULL,
      NULL,
      2.206101,
      3.368657,
      1,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.736928,
      NULL,
      NULL,
      3.643619,
      0,
      2,
      0,
      NULL,
      NULL,
      NULL,
      2,
      1.456249,
      1,
      NULL,
      1.607145,
      NULL,
      0.393590,
      1,
      1.693089,
      0.938799,
      1,
      0,
      0,
      1,
      1,
      NULL,
      0.606672,
      0,
      0.547471,
      1,
      1.202649,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.598993,
      0.193512,
      7,
      NULL,
      2.593451,
      NULL,
      NULL,
      NULL,
      NULL,
      6.198046,
      3,
      5,
      1.299890,
      3.673045,
      8,
      3,
      2,
      4.832704,
      NULL,
      6,
      6.874547,
      3,
      5.583122,
      0,
      3,
      2.259587,
      NULL,
      0.401146,
      2.098900,
      1.200640,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      1,
      1,
      1,
      1.408981,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      9.433181,
      2.691769,
      0,
      0.755823,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      9.071342,
      0.271401,
      0.464370,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.349196,
      7,
      1.469652,
      1.012481,
      NULL,
      7.194580,
      NULL,
      3.960099,
      0,
      1.872157,
      0.717345,
      NULL,
      NULL,
      NULL,
      0.933600,
      2,
      3,
      0.160058,
      NULL,
      1.403701,
      0,
      0.020031,
      NULL,
      0.406706,
      0.498364,
      0.414009,
      1.500559,
      0,
      0.517587,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      '14230',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      0.160159,
      '',
      '',
      '',
      2.666232,
      5,
      1.441354,
      0.031599,
      0.159209,
      2.364910,
      2.138337,
      2.709998,
      0.936406);
commit;
end;
/


