set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9649566';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-9-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '232',
      '43144013',
      NULL,
      5,
      NULL,
      84.773502,
      1,
      NULL,
      2,
      '243442',
      5,
      NULL,
      54.747361,
      6.691732,
      1.794219,
      NULL,
      1,
      0.888882,
      1,
      1,
      1.762992,
      0,
      0.940475,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.593927,
      0.676778,
      1.511110,
      9,
      8,
      1.509367,
      0.996512,
      0,
      1,
      NULL,
      2.910244,
      NULL,
      4,
      2.170945,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.508921,
      0.335339,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.246264,
      NULL,
      NULL,
      NULL,
      1,
      0.138397,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.203449,
      0,
      NULL,
      1,
      1.412714,
      1,
      1,
      0.704568,
      1,
      NULL,
      NULL,
      0.112506,
      NULL,
      1.143819,
      0,
      NULL,
      0.635966,
      1.105857,
      0.609129,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      3.607525,
      1.470978,
      3.255959,
      NULL,
      NULL,
      NULL,
      NULL,
      5.175708,
      0,
      7,
      0,
      1.538858,
      NULL,
      4.039003,
      5.676304,
      4.414220,
      3,
      NULL,
      0,
      5,
      1,
      0.606055,
      1.814656,
      NULL,
      4,
      0.371797,
      0,
      1.827156,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.578940,
      1,
      1,
      1,
      1.497511,
      0.565988,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.538509,
      3.397886,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.151192,
      1.208862,
      6.388653,
      NULL,
      NULL,
      0,
      0.035768,
      NULL,
      NULL,
      NULL,
      0.691719,
      3.108379,
      1.364014,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.119241,
      NULL,
      0,
      0,
      NULL,
      0,
      3,
      1,
      0,
      3,
      NULL,
      0,
      1.974106,
      0.500286,
      NULL,
      NULL,
      1,
      1.517874,
      1,
      1.956147,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.641013,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.797759,
      '41344',
      '',
      '',
      0,
      '',
      '',
      '',
      0,
      '',
      '',
      NULL,
      0.803147,
      7,
      NULL,
      2,
      4,
      2,
      NULL,
      1.479244,
      0);
commit;
end;
/


