set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9649566';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-10-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '23343342',
      1,
      2,
      '4213003',
      NULL,
      5,
      0,
      1,
      NULL,
      0,
      NULL,
      14,
      24,
      1.996186,
      NULL,
      0.410772,
      1.721242,
      3.352600,
      0,
      NULL,
      0,
      0,
      1.166468,
      1,
      1,
      7,
      1.634287,
      2.240149,
      1,
      1.727787,
      0.729211,
      5.772478,
      0,
      6,
      1,
      1.683651,
      1,
      3.503561,
      0,
      2.079347,
      3.110325,
      3.175132,
      1.602404,
      NULL,
      NULL,
      1.816126,
      NULL,
      NULL,
      NULL,
      0.239072,
      NULL,
      1.111619,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.038100,
      1,
      0.791929,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2.803350,
      0,
      3.030624,
      NULL,
      0.158731,
      0,
      1.374456,
      NULL,
      0,
      1,
      0.121183,
      0,
      1,
      0,
      0,
      0.303022,
      NULL,
      NULL,
      0,
      3,
      NULL,
      0.197370,
      0,
      0.931881,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      5,
      5.331115,
      0.864912,
      NULL,
      0.397271,
      NULL,
      NULL,
      4.422936,
      NULL,
      9.197461,
      0.104324,
      4,
      0,
      0.066375,
      0,
      NULL,
      NULL,
      1,
      1.628858,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.982175,
      0,
      0,
      1.724148,
      NULL,
      1,
      1.029208,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.666673,
      NULL,
      6.100098,
      0,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.229964,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.592193,
      0.307674,
      7,
      0,
      6.027248,
      1,
      1.895580,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.834312,
      NULL,
      0.120251,
      1,
      3,
      NULL,
      2,
      NULL,
      NULL,
      2.474279,
      NULL,
      0.975961,
      0,
      1.447570,
      1.760367,
      0,
      1,
      1,
      NULL,
      1.967461,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      '',
      NULL,
      1,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      2.878376,
      3.037284,
      3.659023,
      7.315391,
      NULL,
      2,
      2,
      3,
      0.082170);
commit;
end;
/


