set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9649566';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-4-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '04332303',
      30.382679,
      72.682488,
      '3131131',
      79,
      6,
      2.452715,
      NULL,
      '031133',
      0.456732,
      '10-27-1999',
      47,
      222,
      1.223602,
      NULL,
      NULL,
      2,
      1.085155,
      0,
      0.869283,
      0.759688,
      1,
      2.638507,
      0.791637,
      0.334350,
      8.481955,
      NULL,
      NULL,
      1,
      1,
      0,
      3,
      0.093138,
      NULL,
      0,
      NULL,
      0.866458,
      6,
      1,
      4,
      3.405628,
      1,
      1.047943,
      NULL,
      NULL,
      0,
      3,
      3.598117,
      1,
      NULL,
      NULL,
      0.798975,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.797874,
      0.548200,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.887062,
      1.945297,
      1.779634,
      0,
      0.011967,
      0,
      0,
      0,
      1.364934,
      0.815385,
      1.397159,
      1,
      0,
      0.449241,
      NULL,
      1,
      0.003471,
      0.570896,
      0.781832,
      NULL,
      1,
      2,
      NULL,
      4,
      3.997642,
      0,
      4,
      0,
      3.540170,
      2,
      2.512260,
      6,
      1.136733,
      4,
      6,
      1,
      1.923049,
      1.850423,
      NULL,
      8,
      7.140647,
      2.781483,
      8,
      6.057572,
      4.124060,
      NULL,
      0,
      NULL,
      1,
      1.685668,
      0.770271,
      5.343469,
      0.610059,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.572317,
      1,
      2,
      1,
      0,
      0.555988,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      4,
      1.064747,
      1.568085,
      1.902696,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.925375,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5.522614,
      8.819446,
      5.595572,
      0.328205,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      4,
      5,
      4,
      0,
      0.860403,
      0,
      NULL,
      0,
      0.339205,
      NULL,
      NULL,
      1.308010,
      2.990367,
      1.694276,
      1,
      NULL,
      0.851761,
      0,
      1.232275,
      1.078787,
      1,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      1.289363,
      '',
      '',
      NULL,
      2.355104,
      6.179096,
      0,
      5.164033,
      3,
      NULL,
      0,
      0.408403,
      3.509628);
commit;
end;
/


