set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9649566';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-10-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      30,
      70,
      '2344033',
      125.071682,
      2,
      3.250096,
      NULL,
      NULL,
      1.695100,
      ' 1-19-1994',
      64,
      NULL,
      1.110119,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      1,
      1,
      0.690915,
      1,
      7,
      1,
      0,
      0.218310,
      0.214043,
      5.317099,
      5,
      1,
      0,
      0,
      1,
      1,
      7,
      1,
      NULL,
      NULL,
      0.425022,
      1.291886,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.665941,
      1,
      0.150556,
      4,
      0,
      1,
      1,
      1.795856,
      NULL,
      NULL,
      0.958385,
      NULL,
      NULL,
      1,
      0.703723,
      NULL,
      1,
      1.868076,
      0.053166,
      0.501683,
      0,
      1.695703,
      1,
      1.024712,
      0.956705,
      1.957768,
      1,
      0.198371,
      NULL,
      1.211502,
      0.843472,
      1.689323,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.399607,
      1.652911,
      1,
      2.278753,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      6.675886,
      4.353435,
      1.932010,
      1.045271,
      2.058362,
      NULL,
      2,
      NULL,
      NULL,
      2,
      NULL,
      4,
      0.927677,
      NULL,
      NULL,
      2,
      0,
      0.828864,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.166246,
      1.899343,
      0,
      1,
      NULL,
      0,
      0.274347,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.889377,
      NULL,
      6.760995,
      2,
      NULL,
      0.310821,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.318285,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.296781,
      0.012884,
      2,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1.152314,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      2,
      1.320948,
      2,
      2,
      2,
      0.255401,
      0.735983,
      0.673966,
      1.344034,
      1.141892,
      NULL,
      1,
      NULL,
      1.558490,
      1.339883,
      NULL,
      1.799739,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.030406,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      '',
      NULL,
      0,
      '',
      NULL,
      '',
      1.856704,
      '',
      '',
      NULL,
      1.076678,
      NULL,
      0,
      1,
      3.021921,
      1.574067,
      NULL,
      3,
      2.362855);
commit;
end;
/


