set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9649566';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-10-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1240',
      '43300313',
      28,
      72.861853,
      '1430203',
      NULL,
      0,
      3,
      NULL,
      '322320',
      NULL,
      ' 6-19-1991',
      30,
      26.806305,
      0,
      NULL,
      0.500069,
      1.957825,
      3,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.114817,
      1,
      0.386634,
      0.352147,
      NULL,
      NULL,
      1,
      2,
      NULL,
      0.083200,
      0.993796,
      1.430074,
      1,
      NULL,
      3,
      1,
      3,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1.282881,
      NULL,
      NULL,
      0.429314,
      1.198034,
      NULL,
      0.283873,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.341190,
      1,
      1,
      2.075834,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      1,
      1.224755,
      0.576157,
      1.045225,
      1,
      1.887822,
      1,
      0.734866,
      1,
      1,
      0,
      0.992025,
      NULL,
      NULL,
      0,
      0.173350,
      1.691890,
      NULL,
      1,
      2.823559,
      0,
      1.700759,
      1.195842,
      1,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.868878,
      3,
      0,
      1.974288,
      1,
      NULL,
      0,
      7,
      5.990393,
      0.325599,
      2,
      0,
      7,
      0,
      NULL,
      NULL,
      1.149615,
      NULL,
      NULL,
      5,
      1.835788,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.539678,
      1,
      0,
      0,
      0.727204,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.189869,
      NULL,
      5.659075,
      0,
      0,
      1.506913,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.887996,
      2.060056,
      0.661524,
      NULL,
      NULL,
      NULL,
      1.834392,
      0.166850,
      NULL,
      1,
      3.091788,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.274188,
      0.926063,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.653925,
      NULL,
      NULL,
      1.620198,
      1,
      2.457400,
      0.847197,
      2.028206,
      0,
      0.541044,
      0.744157,
      1,
      0.271547,
      1,
      0,
      0,
      0,
      0.054176,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.106252,
      '31034',
      NULL,
      NULL,
      NULL,
      '',
      NULL,
      '',
      0,
      '',
      '',
      '',
      3,
      4,
      0,
      1.878810,
      3.048516,
      NULL,
      1.791127,
      1,
      2);
commit;
end;
/


