set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9621028';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-3-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '202',
      NULL,
      NULL,
      24.694280,
      NULL,
      1,
      3,
      0,
      3,
      '040420',
      1.495959,
      '10-28-1982',
      58,
      NULL,
      1.227870,
      NULL,
      NULL,
      2,
      1.552606,
      NULL,
      0,
      0,
      0.754068,
      3.659666,
      0.272313,
      NULL,
      4,
      1,
      NULL,
      5.131113,
      0,
      0.636297,
      0.087572,
      0,
      0,
      0.709515,
      6.701522,
      7.262776,
      0,
      0,
      3.299195,
      1.669044,
      NULL,
      0.070321,
      NULL,
      NULL,
      0.665561,
      NULL,
      NULL,
      0,
      NULL,
      1.778013,
      3.411604,
      0.783441,
      1.116868,
      0.792648,
      1,
      2,
      NULL,
      1,
      0,
      0.851282,
      3,
      0,
      0,
      3,
      NULL,
      1,
      0,
      1.330508,
      0.638476,
      0,
      1,
      0,
      3,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.853523,
      NULL,
      NULL,
      1,
      0.274655,
      5.229510,
      0,
      0,
      1,
      NULL,
      0,
      1.959670,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      3.474337,
      4,
      2.200878,
      6,
      0.901872,
      6,
      0.565329,
      7.780255,
      1,
      2.579853,
      1,
      NULL,
      1.030838,
      2.841593,
      0.210447,
      1,
      NULL,
      NULL,
      0,
      4,
      5,
      5.798808,
      3.776046,
      5,
      1,
      0,
      NULL,
      1,
      1.082663,
      1,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.212156,
      NULL,
      0,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      1.843924,
      0.218763,
      0.995307,
      10,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.167566,
      1.090021,
      5,
      5,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.988570,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.041005,
      0,
      0.434846,
      2.620326,
      0,
      NULL,
      0.599536,
      0.084551,
      1.356121,
      2.006253,
      3,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0.269038,
      1.585997,
      0.132381,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.993968,
      '34123',
      '',
      '',
      1,
      '',
      '',
      NULL,
      0,
      '',
      '',
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


