set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9621028';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-7-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '431',
      NULL,
      32,
      15.120752,
      '2341320',
      1.924329,
      4,
      1,
      1,
      '312020',
      2.057550,
      ' 9-25-1986',
      70.757086,
      NULL,
      1,
      NULL,
      3.263699,
      0,
      3,
      0.566248,
      1,
      NULL,
      3.342711,
      0.016464,
      NULL,
      0.463979,
      3.990818,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.348404,
      NULL,
      0.611685,
      0,
      2,
      0,
      0.122715,
      1,
      NULL,
      3,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      6,
      NULL,
      0.055705,
      3.332571,
      0,
      0,
      3.661827,
      3,
      2.333262,
      3,
      1.089251,
      0,
      0.448821,
      3.904197,
      NULL,
      0.936743,
      3,
      0.725818,
      1,
      0.867839,
      0.674599,
      NULL,
      2.168062,
      0,
      NULL,
      1.556757,
      0,
      NULL,
      NULL,
      1.844835,
      NULL,
      NULL,
      1,
      1.597738,
      2,
      1.152812,
      6,
      1,
      3.073304,
      1,
      0,
      2.672444,
      1,
      1.862418,
      0.672879,
      4.694844,
      NULL,
      0.393289,
      0,
      1.617993,
      0,
      NULL,
      0,
      0.630116,
      4.316981,
      3,
      0,
      1,
      6,
      0.520895,
      4,
      NULL,
      5,
      NULL,
      1,
      NULL,
      NULL,
      3.070334,
      NULL,
      4,
      2.923520,
      3.503729,
      5,
      0.648007,
      1,
      8,
      NULL,
      NULL,
      1.396626,
      0,
      3.723088,
      1,
      NULL,
      1.834648,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.487496,
      NULL,
      1,
      1,
      1.595402,
      NULL,
      0,
      0.108224,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.127755,
      5.573121,
      NULL,
      1.192761,
      2,
      3.992512,
      3.748881,
      2,
      NULL,
      0.867450,
      2.575885,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.180882,
      3,
      2,
      7.918571,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4.082881,
      1.026337,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      3,
      0.402827,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      1.332396,
      0,
      0,
      1.181476,
      NULL,
      1,
      1.742494,
      NULL,
      1.757896,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.714490,
      '10203',
      NULL,
      '',
      0,
      '',
      NULL,
      '',
      0,
      '',
      '',
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


