set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9621028';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-1-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '231',
      '14',
      NULL,
      7,
      '4423214',
      NULL,
      5,
      2.694265,
      2,
      '240013',
      0,
      '11- 7-1990',
      101.114491,
      11.608885,
      0,
      NULL,
      NULL,
      2.058890,
      0.285667,
      1.452740,
      0,
      1.364358,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0.883279,
      NULL,
      1.660581,
      1,
      1.120480,
      3.482184,
      1.992415,
      NULL,
      0,
      7,
      0,
      2,
      0,
      5.742098,
      2,
      3.761510,
      0,
      NULL,
      NULL,
      1.429003,
      NULL,
      NULL,
      2.575404,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0.492284,
      NULL,
      0.723809,
      3.166538,
      0.466938,
      1.546704,
      2.265018,
      0.792884,
      1,
      3,
      NULL,
      0,
      0.368997,
      NULL,
      1,
      6,
      NULL,
      1,
      3,
      1.329898,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      5.016418,
      1,
      1.365039,
      7,
      0.162823,
      NULL,
      0,
      0.529399,
      NULL,
      0.681569,
      1,
      1,
      NULL,
      0.584202,
      1.263417,
      0,
      1.031713,
      0.438447,
      NULL,
      1.216299,
      4,
      NULL,
      2.539028,
      5.482047,
      3.232452,
      2.645147,
      0.270620,
      5,
      5.958853,
      NULL,
      0,
      4,
      1.898415,
      2.499254,
      3,
      1,
      3,
      1,
      NULL,
      0.438677,
      7,
      3,
      1,
      4,
      NULL,
      1,
      0,
      NULL,
      1,
      0.703684,
      2.738381,
      0.925891,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.708804,
      1,
      0,
      NULL,
      0,
      1,
      1.152341,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.412169,
      NULL,
      0,
      NULL,
      0,
      NULL,
      3.092610,
      0.834507,
      0,
      0.027600,
      7.522598,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      6.850857,
      3,
      2,
      6,
      0,
      6,
      1,
      NULL,
      NULL,
      NULL,
      4,
      3,
      3,
      0,
      2.258891,
      4.907163,
      1,
      1.051490,
      1,
      1,
      2.809858,
      NULL,
      1,
      0.396866,
      0,
      1.837632,
      NULL,
      3.972835,
      3.770943,
      0,
      1,
      0.351596,
      NULL,
      NULL,
      1.219281,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.434159,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      '',
      0.173187,
      NULL,
      '',
      '',
      0,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


