set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9621028';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-6-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '40',
      26,
      20.560567,
      NULL,
      29.664987,
      NULL,
      3,
      NULL,
      '323344',
      1,
      ' 1-20-1993',
      110,
      21.452229,
      1,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0.287465,
      2.915606,
      0.765526,
      1.784776,
      1.308861,
      1,
      NULL,
      NULL,
      1.449448,
      2,
      NULL,
      0.762900,
      4.381217,
      NULL,
      1,
      6.110312,
      NULL,
      1,
      1,
      2,
      1.828439,
      NULL,
      NULL,
      0.891164,
      NULL,
      NULL,
      4.106377,
      7,
      0,
      2.331598,
      0,
      0,
      2,
      NULL,
      3,
      3.969207,
      NULL,
      2.530644,
      NULL,
      1,
      1,
      NULL,
      3,
      3.810352,
      NULL,
      0.972562,
      1,
      0,
      6.656943,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.967630,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.815646,
      2,
      0.126904,
      0.997897,
      1.323481,
      NULL,
      0.045387,
      0,
      1,
      0.198899,
      1,
      0,
      1,
      NULL,
      0,
      0.827743,
      NULL,
      NULL,
      NULL,
      1,
      1.628509,
      3,
      2.994729,
      4,
      0.843006,
      3,
      5,
      4,
      0,
      NULL,
      1,
      1,
      5.314381,
      1.868131,
      2.497995,
      3.523091,
      4.812061,
      NULL,
      0,
      NULL,
      6.805152,
      0,
      1,
      1.161651,
      1,
      3.422466,
      NULL,
      NULL,
      4.609903,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.883685,
      0.253139,
      1.594805,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.978491,
      NULL,
      NULL,
      3,
      0.897964,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.159000,
      3.149113,
      1,
      NULL,
      NULL,
      NULL,
      0.889356,
      NULL,
      4,
      3.742090,
      NULL,
      NULL,
      5.281674,
      1.502700,
      NULL,
      NULL,
      NULL,
      1,
      0.081451,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.415638,
      NULL,
      3.041143,
      NULL,
      NULL,
      3.097607,
      3.877873,
      0.151747,
      3.451470,
      2.446012,
      0.176182,
      1.528868,
      0.693716,
      NULL,
      NULL,
      NULL,
      1.334131,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      '',
      '',
      0.068398,
      '',
      NULL,
      '',
      1.784661,
      NULL,
      NULL,
      '',
      5.291175,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


