set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9621028';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-2-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '022',
      '43',
      0.995999,
      1,
      '2431133',
      32,
      2,
      NULL,
      1,
      '332433',
      1.791019,
      ' 4-24-1997',
      130.197421,
      25.553925,
      0,
      NULL,
      0,
      2.414667,
      0.340990,
      0.172669,
      0,
      NULL,
      NULL,
      NULL,
      0.660468,
      NULL,
      1.944891,
      1.593452,
      1.038986,
      2,
      NULL,
      0,
      2.156392,
      0,
      0.029871,
      2,
      7.420574,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.235460,
      NULL,
      NULL,
      4,
      6,
      4,
      NULL,
      NULL,
      NULL,
      2,
      0.552405,
      0.113012,
      2.506859,
      0.607101,
      NULL,
      3,
      3,
      0,
      0,
      0,
      1.737063,
      NULL,
      NULL,
      1,
      2.698402,
      3,
      0,
      0,
      1.427395,
      1,
      NULL,
      NULL,
      1.926086,
      NULL,
      NULL,
      0,
      NULL,
      0.999586,
      1.227801,
      4,
      0.835735,
      1,
      1.984308,
      1.552608,
      4,
      0.380613,
      2.478886,
      1.012145,
      4.033575,
      0.504178,
      0.254878,
      0.699740,
      1.200522,
      NULL,
      NULL,
      NULL,
      5,
      2,
      NULL,
      1.773726,
      1.224319,
      NULL,
      0,
      NULL,
      4.034030,
      NULL,
      1,
      5,
      NULL,
      6,
      0.947402,
      4.046366,
      1,
      NULL,
      6.144347,
      1,
      3.454756,
      NULL,
      5.086663,
      NULL,
      0.309626,
      0,
      1.310141,
      2.858170,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.139568,
      1.746676,
      NULL,
      0,
      1,
      1,
      0.914046,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.943224,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      5,
      NULL,
      2.350550,
      0.784580,
      1,
      2,
      NULL,
      NULL,
      NULL,
      1,
      0.052857,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.452862,
      2,
      0,
      1,
      3,
      0,
      3.748682,
      1.923679,
      2.278641,
      0,
      NULL,
      1.866239,
      1.217938,
      0,
      NULL,
      NULL,
      0.483963,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.446424,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '30013',
      '',
      '',
      1.913159,
      '',
      '',
      '',
      1,
      NULL,
      '',
      NULL,
      1.481042,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


