set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9204382';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-2-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '122',
      '12401112',
      20,
      32.066195,
      '4040221',
      NULL,
      2,
      NULL,
      3,
      '433124',
      3.901555,
      NULL,
      268,
      16,
      0,
      NULL,
      0,
      1.088489,
      1.820988,
      0,
      1,
      1.968329,
      3.482024,
      2.766987,
      2,
      NULL,
      NULL,
      0,
      1.729419,
      NULL,
      0,
      1.812302,
      NULL,
      NULL,
      NULL,
      0.650606,
      0.888328,
      1,
      0.438676,
      1,
      2,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      2.544735,
      0.252108,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.422395,
      NULL,
      NULL,
      4,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      3,
      4,
      0,
      4,
      0.540123,
      0,
      1.365960,
      NULL,
      1.565678,
      4,
      1.265499,
      NULL,
      0,
      1,
      1.079983,
      NULL,
      NULL,
      2,
      1.566957,
      0.289662,
      NULL,
      NULL,
      6,
      0.747451,
      NULL,
      1.550272,
      1.437512,
      NULL,
      2.688542,
      0,
      3.678092,
      6,
      2,
      NULL,
      NULL,
      NULL,
      5,
      1.621215,
      4,
      1,
      NULL,
      4,
      0,
      3,
      NULL,
      NULL,
      1,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.136030,
      1,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      4.546356,
      0,
      NULL,
      1,
      1.122863,
      NULL,
      0.176570,
      1,
      5.784440,
      1.224266,
      0.821926,
      1.515123,
      NULL,
      NULL,
      NULL,
      0.727646,
      1.387374,
      0,
      7.634508,
      0.378004,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.923135,
      5.331872,
      0.111331,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.078557,
      2,
      NULL,
      1.916855,
      3,
      1,
      NULL,
      NULL,
      3.918105,
      2.353337,
      1,
      0.319016,
      0.246088,
      0.438273,
      1,
      NULL,
      0.820128,
      0,
      NULL,
      1.870790,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      '24003',
      '34430',
      0,
      '',
      '',
      '',
      0,
      '20422',
      '2113',
      '',
      0,
      NULL,
      NULL,
      2.248280,
      2,
      0.289699,
      0.903372,
      0.276029,
      1.397316);
commit;
end;
/


