set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9204382';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-5-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '014',
      NULL,
      42,
      11,
      '2101004',
      16.469524,
      5,
      2.301234,
      NULL,
      '443033',
      2.301178,
      '10-10-1981',
      13.125013,
      29.032469,
      0.505614,
      NULL,
      2.803988,
      0.987479,
      NULL,
      1.338714,
      2,
      1,
      2,
      2.735718,
      3,
      1.809419,
      3.546533,
      0,
      1,
      NULL,
      0.860812,
      0,
      NULL,
      0,
      0,
      1,
      1,
      1,
      7.062744,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.516840,
      NULL,
      NULL,
      3.192219,
      1.136342,
      1.969694,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.568848,
      0,
      3.839874,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0.767202,
      4,
      0,
      1.347404,
      NULL,
      NULL,
      1.357672,
      NULL,
      NULL,
      0,
      6,
      1,
      NULL,
      1,
      0.744529,
      NULL,
      0.792451,
      1.765460,
      NULL,
      1.923429,
      0,
      NULL,
      1.708742,
      4,
      2.093625,
      5.750717,
      1.322796,
      0,
      2.352879,
      3,
      4.120697,
      0.049452,
      NULL,
      0.714627,
      2,
      NULL,
      4,
      NULL,
      2.561193,
      7.226436,
      1,
      NULL,
      1,
      9.694597,
      NULL,
      NULL,
      2,
      1.940281,
      0,
      NULL,
      4.916103,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.775194,
      2,
      NULL,
      1,
      NULL,
      1.235425,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.821329,
      NULL,
      6.437589,
      3,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.667406,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.501887,
      0.447501,
      1,
      NULL,
      2,
      0,
      0.513943,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.371058,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.611172,
      1.500053,
      3,
      NULL,
      NULL,
      1,
      NULL,
      3.196799,
      1.909566,
      0,
      1,
      1.586218,
      1,
      0,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.509400,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '10411',
      '20203',
      '02301',
      1,
      '',
      NULL,
      '',
      1.256809,
      '11310',
      NULL,
      '',
      3,
      NULL,
      3,
      NULL,
      3.037793,
      2.844168,
      1,
      3.689354,
      1.154246);
commit;
end;
/


