set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9204382';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-10-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '300',
      NULL,
      NULL,
      NULL,
      '1124024',
      31,
      NULL,
      5.786149,
      2,
      '242313',
      NULL,
      ' 0- 3-1979',
      205,
      NULL,
      1.678793,
      NULL,
      0.907025,
      0,
      0.464055,
      0.858102,
      1,
      1.061311,
      NULL,
      3.026086,
      2.087537,
      0.893116,
      3.519140,
      1,
      0.818915,
      1,
      1.977353,
      NULL,
      0.235958,
      NULL,
      1,
      1,
      NULL,
      0.363004,
      7.104498,
      1,
      NULL,
      0,
      1,
      1.405756,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.163896,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.729559,
      0.443789,
      0,
      1.602297,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.128716,
      3.420038,
      NULL,
      2.340390,
      1.437616,
      NULL,
      2.919110,
      1,
      4,
      NULL,
      2,
      0.429425,
      0,
      1,
      0.100991,
      0,
      NULL,
      0,
      NULL,
      1.648908,
      1,
      1,
      2,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.651911,
      2,
      NULL,
      NULL,
      2,
      NULL,
      5.207348,
      3,
      0.426217,
      7.697502,
      0,
      2.864355,
      5,
      5,
      NULL,
      0.715727,
      NULL,
      0.659176,
      0.688279,
      0.455981,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      0,
      0.198496,
      2.985524,
      2,
      1.209786,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      3.063407,
      0.626030,
      0.137543,
      0.239021,
      1,
      NULL,
      0.741482,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.740401,
      1,
      5,
      0.113803,
      NULL,
      NULL,
      0.991900,
      NULL,
      NULL,
      NULL,
      0.741602,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.899136,
      1.628864,
      NULL,
      2.894017,
      NULL,
      2.652593,
      0,
      1,
      3.284865,
      1,
      1.437216,
      1,
      0,
      NULL,
      0.819882,
      1.220326,
      NULL,
      0.623507,
      1.792569,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.072839,
      '20314',
      '04410',
      '03413',
      1,
      '',
      NULL,
      '',
      2,
      '31123',
      '2140',
      '',
      NULL,
      0.016338,
      0,
      0,
      0.069967,
      1.044553,
      NULL,
      NULL,
      0);
commit;
end;
/


