set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9204382';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-10-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '131',
      NULL,
      26,
      41,
      '1201041',
      48,
      2,
      2,
      2,
      '020440',
      4,
      ' 4-17-1995',
      150,
      6,
      1.141170,
      NULL,
      NULL,
      0,
      2.224849,
      1.953964,
      0,
      1,
      0.648706,
      2.451356,
      3,
      0,
      0,
      0.487671,
      1,
      1.907922,
      1.949019,
      0,
      0.841059,
      0,
      1.469305,
      1,
      1,
      NULL,
      0,
      0,
      0.961497,
      1,
      1.332336,
      1.002881,
      NULL,
      NULL,
      1.029277,
      NULL,
      NULL,
      3,
      0,
      1.651832,
      1.383366,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.602610,
      1,
      1.980475,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      5,
      1.669106,
      4.802260,
      1,
      NULL,
      1.564077,
      1,
      0.543647,
      1.467523,
      3.836204,
      0,
      4,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      0,
      0,
      3,
      NULL,
      3.551145,
      1,
      NULL,
      0.459236,
      3,
      0.490709,
      0,
      0.624475,
      NULL,
      NULL,
      5.325869,
      4,
      1.714180,
      7.168840,
      3.099006,
      7.385361,
      2.708904,
      0,
      2.703340,
      6,
      9.078900,
      0.341029,
      NULL,
      1,
      0,
      1.712652,
      1.382548,
      9,
      1.794370,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.754392,
      NULL,
      2,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.673782,
      3.019040,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.281522,
      1,
      0.292590,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.262144,
      2.999648,
      NULL,
      1,
      0.163751,
      1,
      3,
      1.290646,
      1.501433,
      0,
      NULL,
      0.298665,
      1.515216,
      0.546832,
      1.164915,
      1.346117,
      1.008408,
      1.350523,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      6,
      '30430',
      '21143',
      '13130',
      1.580379,
      '',
      '',
      '',
      1.405492,
      '01101',
      '0344',
      '',
      NULL,
      2.783197,
      1.042166,
      0.540040,
      3.231453,
      3.234641,
      NULL,
      0,
      2);
commit;
end;
/


