set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9204382';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-5-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '31331003',
      NULL,
      36.123122,
      '0124013',
      NULL,
      3,
      4,
      2,
      NULL,
      2.238292,
      NULL,
      128,
      33,
      1,
      NULL,
      NULL,
      0,
      3,
      0.417799,
      0.596975,
      3.469841,
      NULL,
      1,
      0,
      0.034667,
      2.835057,
      0.591907,
      NULL,
      0,
      1,
      1,
      0,
      1,
      NULL,
      1,
      0.678023,
      1.334696,
      1.794749,
      1,
      1.690604,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1.475028,
      9,
      2,
      NULL,
      NULL,
      3.055846,
      NULL,
      1.895381,
      1.477934,
      0.883644,
      1,
      NULL,
      NULL,
      0.826754,
      NULL,
      1,
      2.692896,
      3,
      0,
      0,
      1.595638,
      3.751555,
      0,
      NULL,
      1.772247,
      0.245541,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.091047,
      0,
      0.714912,
      NULL,
      2.479335,
      1.722832,
      NULL,
      1.162652,
      3.441558,
      1.112108,
      1,
      1.232459,
      1.588464,
      0,
      0.851632,
      1.043433,
      1.231820,
      0,
      NULL,
      0.990938,
      0.494098,
      NULL,
      0,
      0,
      NULL,
      0,
      1,
      3.088774,
      0,
      0,
      1,
      0,
      NULL,
      2.838988,
      1.788067,
      3,
      2.879699,
      4.702171,
      NULL,
      4,
      0,
      5,
      NULL,
      NULL,
      1,
      2.975606,
      NULL,
      3.330592,
      0.682485,
      0,
      0.440975,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.754940,
      NULL,
      0,
      1,
      0,
      NULL,
      1.724665,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.869614,
      NULL,
      NULL,
      NULL,
      NULL,
      2.270605,
      1.050693,
      2,
      0,
      0.183679,
      4.561262,
      1.820507,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.584045,
      NULL,
      0,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.388953,
      1,
      1.764264,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.566811,
      3.833301,
      1,
      0.060274,
      0,
      1,
      NULL,
      1.932094,
      0,
      0,
      0.125640,
      0.976648,
      0.381491,
      NULL,
      0,
      0.749962,
      0.464474,
      NULL,
      1.155394,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5.726899,
      NULL,
      '20424',
      NULL,
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      '04120',
      NULL,
      '',
      4.400748,
      3,
      3,
      0.768641,
      1,
      1,
      3,
      0.623922,
      1);
commit;
end;
/


