set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9204382';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-1-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      19.967511,
      0.476817,
      '4001343',
      10,
      NULL,
      1,
      0,
      NULL,
      1,
      ' 4-27-1980',
      150,
      NULL,
      1,
      NULL,
      1.521462,
      NULL,
      1.041482,
      NULL,
      1.796986,
      3,
      0.712771,
      3.261578,
      NULL,
      0,
      4.321402,
      0.813960,
      NULL,
      NULL,
      0.609585,
      1.595981,
      0,
      0,
      0,
      1.921400,
      1.677732,
      0.555524,
      4,
      0,
      1,
      0.899097,
      1.299326,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      4.891320,
      NULL,
      1,
      1,
      0,
      2.652258,
      2,
      1.465734,
      0,
      0,
      NULL,
      0,
      2.522092,
      0.867037,
      3,
      NULL,
      NULL,
      3.453969,
      NULL,
      0.192646,
      1.847664,
      NULL,
      1,
      0,
      0.899964,
      0.287654,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0.002799,
      NULL,
      1.579508,
      0.813572,
      0.779170,
      0,
      NULL,
      1,
      1,
      2,
      0,
      1,
      NULL,
      0.402303,
      0.981322,
      NULL,
      0.350183,
      0.994590,
      0,
      1.971989,
      1,
      1,
      NULL,
      0,
      3.077766,
      1,
      1,
      0,
      1,
      0,
      3.617800,
      1,
      3,
      5.517372,
      5,
      2.441475,
      NULL,
      0,
      0,
      NULL,
      1,
      1,
      4.911696,
      3,
      1.028371,
      1,
      0.884714,
      1,
      0.895633,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.482258,
      NULL,
      1,
      1.816120,
      1.825493,
      0.060759,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.613126,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.833155,
      0,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.373752,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.410982,
      1.279138,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.663241,
      0,
      1,
      1,
      NULL,
      1.751517,
      1,
      1,
      1.152064,
      NULL,
      0,
      0.459955,
      NULL,
      NULL,
      0.806365,
      0.167218,
      1.141995,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.706424,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.302921,
      '02414',
      '31402',
      NULL,
      NULL,
      NULL,
      '',
      '',
      0.958887,
      NULL,
      '0403',
      '',
      5.196714,
      1,
      0,
      0,
      2.603795,
      2,
      2,
      1.477549,
      NULL);
commit;
end;
/


