set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9204382';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-7-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '24113344',
      17,
      NULL,
      '4122413',
      10,
      2,
      1.239795,
      NULL,
      '043310',
      3.245539,
      ' 6-27-1992',
      179.418642,
      NULL,
      NULL,
      NULL,
      3.692108,
      0.406681,
      0,
      0.034977,
      1.595641,
      0,
      1,
      NULL,
      NULL,
      0,
      0,
      1.184656,
      1.519555,
      1,
      0,
      NULL,
      NULL,
      0,
      1.239322,
      1,
      0.091941,
      0,
      1,
      1,
      0.225961,
      0,
      0,
      1,
      NULL,
      NULL,
      0.356895,
      NULL,
      NULL,
      9.161635,
      3.355718,
      NULL,
      2.339231,
      NULL,
      0,
      1,
      1.216173,
      NULL,
      3.889190,
      NULL,
      NULL,
      NULL,
      0.229085,
      1,
      NULL,
      NULL,
      2,
      0.047288,
      0.878370,
      NULL,
      1,
      NULL,
      0,
      0,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.544384,
      NULL,
      0.543778,
      NULL,
      NULL,
      2.909029,
      2,
      NULL,
      1.385361,
      0,
      3,
      0.767774,
      1,
      2,
      1.790223,
      0.146880,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.893929,
      1.638176,
      0.070221,
      1.723395,
      1.636118,
      1,
      1.170836,
      2.197854,
      1.509423,
      0,
      0,
      0,
      NULL,
      2,
      2,
      NULL,
      NULL,
      4,
      4,
      NULL,
      4,
      4,
      NULL,
      6,
      1,
      0,
      3,
      3,
      1.567967,
      1.124450,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      1,
      1.556024,
      NULL,
      0.124912,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      0,
      0.105762,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.153605,
      1,
      0,
      1,
      1,
      2,
      0.943211,
      NULL,
      NULL,
      NULL,
      0,
      1.406977,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      2,
      1.807881,
      1.233103,
      1.503232,
      0,
      0.354831,
      NULL,
      1.521973,
      NULL,
      0.366162,
      NULL,
      NULL,
      0.934634,
      1.909407,
      1.818600,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.655089,
      NULL,
      '00002',
      '01300',
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      '2300',
      '',
      5,
      2,
      3,
      2,
      NULL,
      0.073062,
      2,
      NULL,
      1.603200);
commit;
end;
/


