set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9204382';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-1-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2140',
      NULL,
      11,
      49,
      '4232330',
      12.497017,
      4,
      0,
      0,
      '312404',
      3.893724,
      '11- 6-1989',
      30.066680,
      NULL,
      0.084656,
      NULL,
      NULL,
      NULL,
      1.935612,
      1.227585,
      0,
      NULL,
      1,
      1,
      1,
      0,
      3.183719,
      0.524578,
      0,
      1.341111,
      0,
      1,
      3.303958,
      1,
      0,
      1.839122,
      1.686025,
      0,
      NULL,
      0,
      0,
      0.908999,
      1,
      1.592663,
      NULL,
      NULL,
      0.075320,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2.152495,
      0.612394,
      NULL,
      1.386295,
      3.717289,
      0,
      3.018003,
      3,
      0,
      0,
      0,
      0.791422,
      1,
      0.373414,
      0,
      0.468831,
      NULL,
      1.818590,
      1.352628,
      5,
      0,
      NULL,
      2.341847,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      3,
      1,
      0,
      0,
      1.177629,
      NULL,
      0.169895,
      1.774612,
      3.655232,
      0.575132,
      NULL,
      0.572919,
      NULL,
      1.049108,
      NULL,
      0.030461,
      1.430801,
      NULL,
      1.846507,
      0,
      0,
      0,
      1.192117,
      NULL,
      1,
      0,
      0,
      0.539666,
      1,
      0,
      NULL,
      1.626826,
      0.303136,
      1,
      6,
      6,
      NULL,
      0,
      7.366577,
      0.360959,
      0,
      2,
      5,
      1,
      NULL,
      0.827084,
      3.982940,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      1.248254,
      3.492731,
      1,
      0.980584,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.744463,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      4,
      1.979483,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0.533172,
      1.834031,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.033351,
      2.415891,
      1.098573,
      2.112283,
      NULL,
      0,
      NULL,
      1.227866,
      0,
      0,
      0.219721,
      NULL,
      1,
      1.070488,
      1,
      1.880110,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      5,
      '11121',
      '01432',
      NULL,
      0.779192,
      NULL,
      '',
      NULL,
      3,
      '04010',
      '3213',
      NULL,
      2,
      3.701835,
      3.219010,
      1.770521,
      0,
      2,
      3.597236,
      NULL,
      NULL);
commit;
end;
/


