set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9204382';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-5-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3003',
      '42120243',
      NULL,
      NULL,
      '3310233',
      113,
      4,
      5,
      0,
      '232232',
      NULL,
      '10-27-1979',
      NULL,
      31.356589,
      0,
      NULL,
      0.259317,
      NULL,
      1.173172,
      1.503793,
      1.898335,
      0,
      0.532250,
      NULL,
      1.942662,
      1,
      NULL,
      1.535687,
      NULL,
      NULL,
      1,
      1,
      2.783364,
      0.782474,
      0,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.331769,
      NULL,
      NULL,
      0.406284,
      NULL,
      NULL,
      1.389678,
      9,
      9,
      2.756938,
      0,
      1.642119,
      3,
      0,
      1.324784,
      NULL,
      2,
      NULL,
      0.974306,
      2.040141,
      0,
      1.028477,
      NULL,
      1.716204,
      0,
      3.593734,
      1,
      NULL,
      NULL,
      NULL,
      0,
      4.905953,
      1.546695,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0.047955,
      0,
      1.466654,
      1,
      0.613466,
      5.975327,
      1.638390,
      1,
      5.900762,
      1,
      2.340533,
      1,
      NULL,
      0.413614,
      0.506178,
      NULL,
      0.463724,
      NULL,
      NULL,
      NULL,
      1,
      0.992920,
      NULL,
      0,
      NULL,
      0,
      0.967512,
      NULL,
      NULL,
      NULL,
      NULL,
      2.829406,
      1.599990,
      3.261864,
      3.479159,
      1.266200,
      0.123367,
      6.959356,
      3,
      7,
      0.352765,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      0.296533,
      0.306049,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.093667,
      NULL,
      0,
      0,
      1.734027,
      NULL,
      1.498396,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.445340,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      1.464847,
      NULL,
      NULL,
      NULL,
      1,
      0.262008,
      1.483356,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.839355,
      0.092585,
      0.986024,
      3.776979,
      2.934551,
      2,
      0,
      0,
      NULL,
      3.039942,
      0.869867,
      1,
      1.378984,
      NULL,
      0,
      1.807988,
      0,
      0.082090,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '30230',
      '43403',
      0.183543,
      NULL,
      '',
      '',
      4.441138,
      '32231',
      '2122',
      '',
      5,
      1,
      NULL,
      1.339919,
      3.335955,
      0.787683,
      2.266564,
      1,
      0);
commit;
end;
/


