set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9699006';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-2-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '003',
      NULL,
      4.721382,
      20,
      NULL,
      1,
      2,
      3,
      3,
      '120244',
      NULL,
      NULL,
      131.752222,
      34.580088,
      0.244696,
      NULL,
      0.183351,
      3,
      1,
      1,
      0,
      NULL,
      NULL,
      1,
      2,
      0,
      2,
      0.825927,
      NULL,
      1.079780,
      0,
      1,
      5,
      0.397397,
      2,
      4,
      1.810011,
      0.882267,
      7.525601,
      NULL,
      5.574200,
      1.502394,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      0,
      1.516219,
      0,
      2.860442,
      0.928055,
      2,
      2.252830,
      3,
      0.409017,
      NULL,
      0.546301,
      NULL,
      3.318392,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      9.116782,
      NULL,
      NULL,
      1.153998,
      NULL,
      NULL,
      NULL,
      0.084770,
      NULL,
      NULL,
      0.201748,
      1.015105,
      0,
      0,
      0,
      0.696033,
      1,
      0,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.908178,
      0,
      1,
      1.295342,
      0,
      NULL,
      0.561239,
      0.822747,
      0,
      NULL,
      1.893258,
      1.626412,
      1,
      0,
      1.338471,
      0.956643,
      1,
      0,
      1,
      NULL,
      1,
      0,
      1.239681,
      0,
      0,
      0.755623,
      0.463939,
      NULL,
      6,
      NULL,
      5.781147,
      NULL,
      6,
      NULL,
      1,
      1,
      1.565952,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.899464,
      NULL,
      0,
      0,
      0,
      1.450706,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.833584,
      NULL,
      NULL,
      NULL,
      2.421614,
      0.522489,
      3,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.674033,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.418945,
      1,
      1,
      0.166663,
      3,
      0.014998,
      0,
      1,
      NULL,
      NULL,
      0,
      0.601011,
      0.448559,
      1.106681,
      0,
      1,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.492574,
      '02020',
      '',
      '',
      0.870946,
      '',
      '',
      '',
      1.559384,
      '',
      '',
      '',
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


