set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9699006';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-1-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '44243420',
      20,
      42,
      NULL,
      NULL,
      1,
      3.210869,
      1,
      '004104',
      NULL,
      NULL,
      153,
      102.499563,
      1.911119,
      NULL,
      2,
      NULL,
      2.493853,
      0,
      0.285031,
      1.378269,
      NULL,
      0.263241,
      NULL,
      1,
      1,
      1,
      0,
      0.731289,
      1,
      1,
      NULL,
      1,
      3,
      0.849815,
      1.893391,
      0.165703,
      2.903610,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.814805,
      NULL,
      NULL,
      1.070032,
      0.560331,
      0.675820,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.695437,
      0,
      0.379336,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.710924,
      3.976313,
      2,
      1,
      1.463872,
      3,
      1.727805,
      1.922979,
      1,
      1.391373,
      0.679808,
      0.472533,
      1.754848,
      0,
      1.091403,
      NULL,
      NULL,
      0.517677,
      NULL,
      NULL,
      0.062043,
      NULL,
      NULL,
      0.057103,
      1.536292,
      0.586137,
      4,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1.825668,
      1.538693,
      1,
      1.472015,
      1,
      4.879923,
      0,
      1,
      5,
      1.866298,
      4.370263,
      4.421933,
      6.593198,
      5,
      2.172189,
      4,
      1.896076,
      1.180873,
      1,
      2.138171,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.428169,
      0,
      1,
      2.470696,
      0,
      3.572017,
      0.833001,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.905214,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.992888,
      1.733785,
      0,
      1.268697,
      0,
      0,
      1.142740,
      NULL,
      NULL,
      NULL,
      NULL,
      1.608490,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.566438,
      3.722810,
      2.892666,
      0,
      1.902440,
      NULL,
      0,
      1,
      NULL,
      0,
      1,
      NULL,
      0.050652,
      1.764137,
      0.788107,
      1,
      1.129101,
      NULL,
      0.187485,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.374699,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      '22034',
      '',
      '',
      1,
      '',
      NULL,
      NULL,
      0.859434,
      '',
      '',
      NULL,
      0.832497,
      2,
      0.341675,
      2,
      4,
      3.095276,
      0,
      2,
      1.090092);
commit;
end;
/


