set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9699006';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-8-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '240',
      '12404333',
      4,
      34,
      '2400100',
      5,
      5,
      3,
      1,
      NULL,
      0,
      ' 4-16-1976',
      108,
      83,
      1.367879,
      NULL,
      0.154254,
      1,
      NULL,
      1.544498,
      0.660799,
      0,
      0,
      NULL,
      0,
      1,
      0.163519,
      0.320627,
      1.241678,
      0.205101,
      1.290302,
      0,
      NULL,
      0.060492,
      NULL,
      1.534349,
      7.306772,
      2,
      9,
      1,
      2.219519,
      1,
      0,
      1.244970,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.625052,
      NULL,
      1.752264,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      NULL,
      1,
      2,
      2.484556,
      0.666324,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.379631,
      3,
      1,
      NULL,
      5.469633,
      3,
      1,
      NULL,
      1,
      1.126203,
      1,
      3,
      0.404815,
      2.562693,
      0,
      1.187863,
      NULL,
      0,
      0,
      NULL,
      0.723306,
      1.894400,
      4.918942,
      0.851123,
      0.207581,
      0,
      2.747767,
      1,
      0.828285,
      NULL,
      0.029839,
      0,
      NULL,
      1,
      0,
      0.793059,
      0.751530,
      2.503405,
      0.818522,
      7.143822,
      2.149480,
      0,
      7,
      4,
      1.550482,
      NULL,
      2,
      4,
      0,
      1,
      1.285153,
      2.257212,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.987057,
      1,
      NULL,
      1.497985,
      3,
      NULL,
      1.198041,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.219235,
      0,
      NULL,
      4.912011,
      NULL,
      1,
      1.654163,
      NULL,
      NULL,
      NULL,
      0.850368,
      1,
      1.009685,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      3.720445,
      NULL,
      0.714766,
      1,
      NULL,
      1.598362,
      1.388793,
      3.785092,
      0,
      NULL,
      1.759394,
      1,
      1.481519,
      NULL,
      0.376412,
      0.736563,
      NULL,
      0.451291,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.652315,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      '44043',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      1,
      0,
      2,
      7,
      NULL,
      7.835053,
      2,
      2,
      NULL);
commit;
end;
/


