set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9699006';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-2-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '240',
      NULL,
      63,
      61,
      '1440442',
      29.806850,
      3,
      NULL,
      1,
      '144211',
      1,
      '11- 4-1994',
      3.493181,
      50,
      0,
      NULL,
      1.459050,
      1,
      3,
      1.166670,
      0.401260,
      0,
      1,
      2.969914,
      1.914353,
      1.588353,
      0.220542,
      0.223089,
      NULL,
      NULL,
      0.271455,
      1.181909,
      6,
      NULL,
      NULL,
      0.330253,
      0,
      1.831516,
      1.375480,
      1,
      1,
      1,
      1.245225,
      1,
      NULL,
      NULL,
      0.549008,
      NULL,
      NULL,
      5.667819,
      1.804026,
      0.831803,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.583339,
      1,
      2,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      0.244762,
      NULL,
      NULL,
      NULL,
      1,
      0.783642,
      0,
      NULL,
      1.794130,
      1,
      0,
      0.143543,
      1,
      0,
      1,
      0,
      7.983481,
      1,
      1.781761,
      0.474903,
      0,
      0.357480,
      NULL,
      0.028581,
      0,
      4,
      0,
      1,
      0.796834,
      0.477666,
      1.791585,
      0,
      0.891819,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      1,
      NULL,
      0.231133,
      1,
      4,
      0.811600,
      7.065407,
      6.079079,
      4,
      0.303170,
      0.803652,
      0.501761,
      NULL,
      1,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.353967,
      0,
      1,
      1.976011,
      2,
      0.159545,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.794465,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2.533405,
      NULL,
      0,
      2,
      0.145724,
      NULL,
      NULL,
      NULL,
      0.713519,
      1.072906,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.315821,
      NULL,
      3.027162,
      3.480363,
      0,
      NULL,
      0.126203,
      0.361215,
      1.244679,
      0.397399,
      0,
      0,
      NULL,
      0.759090,
      1,
      0.763192,
      NULL,
      1,
      0.416414,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.976487,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.819420,
      '20403',
      '',
      '',
      1,
      '',
      '',
      NULL,
      0.208345,
      '',
      '',
      '',
      5,
      1,
      0,
      2.071279,
      2.117425,
      2.079572,
      3,
      1,
      NULL);
commit;
end;
/


