set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9699006';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-8-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '43031211',
      7,
      3.587438,
      NULL,
      NULL,
      5,
      0,
      NULL,
      '344140',
      2.885038,
      ' 2-11-1986',
      121,
      74.176252,
      0.182331,
      NULL,
      0.618709,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      NULL,
      0,
      2.212999,
      NULL,
      1.412051,
      0,
      0.426184,
      3,
      4,
      NULL,
      0.747169,
      1,
      0.716439,
      NULL,
      2.489610,
      NULL,
      0,
      2,
      0,
      1.489172,
      NULL,
      NULL,
      1.184987,
      NULL,
      NULL,
      1.186047,
      1,
      0,
      1.434174,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.014964,
      1.882170,
      0,
      0,
      1,
      1.049476,
      0.341573,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.539982,
      0,
      0.294860,
      1.810669,
      0.705065,
      5,
      6,
      NULL,
      1.201272,
      1.579398,
      1,
      1.526354,
      0.631054,
      3.812707,
      1,
      1,
      NULL,
      0.456728,
      1.752367,
      NULL,
      1,
      0,
      5.435671,
      NULL,
      1.096897,
      0,
      NULL,
      1.554606,
      1.597953,
      NULL,
      0.939383,
      NULL,
      1,
      0.772909,
      0,
      1.701334,
      1,
      3,
      3.969911,
      7.643667,
      NULL,
      0,
      2.129331,
      5,
      2.962301,
      5,
      0.997179,
      2.630400,
      2,
      NULL,
      0,
      4,
      0.757026,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.620667,
      2,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.235629,
      1,
      1.393638,
      3,
      0,
      3.207510,
      0,
      1,
      2,
      0,
      NULL,
      0,
      1.146400,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.432400,
      1,
      1.937009,
      NULL,
      0.148495,
      2,
      1.225776,
      NULL,
      0.833296,
      3,
      0.911959,
      1,
      1,
      0,
      NULL,
      1.334273,
      NULL,
      1,
      1.843554,
      1.279738,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      '',
      1,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      2.664061,
      2,
      2,
      1,
      1,
      3.868568,
      3.420122,
      0);
commit;
end;
/


