set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9699006';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-1-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '343',
      NULL,
      20,
      NULL,
      '3330431',
      75,
      6,
      0,
      3,
      '421200',
      1.764645,
      ' 2-26-1986',
      NULL,
      23,
      0,
      NULL,
      1.461527,
      0.457359,
      NULL,
      NULL,
      0.352366,
      1,
      2.236931,
      2,
      3,
      1,
      NULL,
      NULL,
      1,
      1,
      1.309229,
      0,
      2.878605,
      0,
      NULL,
      1,
      0.510130,
      1.209947,
      3,
      NULL,
      3.349864,
      5.592138,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.069234,
      0,
      0.153977,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.416012,
      0.528491,
      NULL,
      6,
      1,
      NULL,
      1.932796,
      0,
      NULL,
      NULL,
      0.742157,
      NULL,
      NULL,
      1,
      0.717303,
      NULL,
      1.421706,
      1,
      9,
      4,
      0.417289,
      NULL,
      2,
      0,
      4.674071,
      0.142735,
      7,
      1.286880,
      0,
      0.007142,
      0.846650,
      NULL,
      NULL,
      NULL,
      1.301558,
      2.810513,
      NULL,
      NULL,
      NULL,
      7.972660,
      0,
      1,
      1.525322,
      0,
      NULL,
      1.444793,
      1,
      1,
      1.107081,
      0,
      5.130968,
      NULL,
      7,
      NULL,
      2.686677,
      5.361427,
      5.537835,
      2,
      0.412709,
      5.577069,
      3,
      1,
      1.676423,
      0.791113,
      8.628390,
      1.453115,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.618399,
      0,
      0,
      1,
      1,
      1.778688,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.531651,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      7.394233,
      NULL,
      1.003303,
      2,
      1.049284,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.715498,
      3.062636,
      1,
      0.671740,
      0.497198,
      2,
      1.478804,
      1,
      1,
      1.029546,
      0,
      1,
      0,
      NULL,
      0,
      0,
      NULL,
      1.781741,
      1.456803,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.870871,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      '12420',
      '',
      NULL,
      0.435839,
      '',
      '',
      '',
      0.404731,
      '',
      '',
      '',
      1.326363,
      NULL,
      0,
      2,
      3,
      2,
      NULL,
      0,
      NULL);
commit;
end;
/


