set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8726488';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-5-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '0',
      NULL,
      NULL,
      '4240243',
      6.966506,
      0,
      0.775943,
      3,
      '332004',
      NULL,
      ' 0-21-1999',
      23.194845,
      NULL,
      0,
      NULL,
      0,
      0.515599,
      1,
      0,
      0,
      0.399583,
      1.776701,
      1,
      0.051926,
      0.097280,
      7.245572,
      NULL,
      0,
      NULL,
      2.917834,
      0.103111,
      1.589787,
      0.375583,
      NULL,
      0.652343,
      NULL,
      1,
      6.907512,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.449407,
      NULL,
      NULL,
      1,
      0.577167,
      NULL,
      3,
      NULL,
      0.574527,
      3.434405,
      2.959692,
      0,
      1,
      1,
      1,
      NULL,
      0.516948,
      NULL,
      0,
      1.280967,
      1.293179,
      0.107164,
      0.327229,
      1.360643,
      NULL,
      5,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.385364,
      NULL,
      NULL,
      1,
      1,
      1.936321,
      NULL,
      1.053931,
      1,
      NULL,
      1,
      1,
      1,
      1.360215,
      NULL,
      0,
      NULL,
      0,
      0.241673,
      1,
      NULL,
      1,
      NULL,
      NULL,
      2.564499,
      1.024411,
      1.412233,
      2.831907,
      0,
      4,
      0,
      1,
      1.755516,
      NULL,
      4,
      NULL,
      0.070235,
      6,
      1.292309,
      0,
      1,
      NULL,
      1.049585,
      NULL,
      4,
      4.024151,
      4,
      8,
      4.812319,
      3,
      0.675674,
      NULL,
      0,
      NULL,
      7,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2,
      0,
      NULL,
      NULL,
      1,
      0.546428,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.288927,
      NULL,
      NULL,
      1.464782,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.311661,
      1,
      0.926277,
      0,
      1.363482,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.358851,
      0,
      NULL,
      NULL,
      3,
      3,
      3.122337,
      1.568486,
      0,
      3,
      NULL,
      NULL,
      1,
      NULL,
      0.316723,
      NULL,
      NULL,
      1.458200,
      1.509276,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      '41330',
      '',
      NULL,
      0.980692,
      '',
      '',
      '',
      0.962780,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


