set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8726488';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-10-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      NULL,
      NULL,
      NULL,
      NULL,
      4.614701,
      3,
      0,
      NULL,
      '143213',
      1,
      ' 9-16-1988',
      8.515260,
      NULL,
      0.489546,
      NULL,
      0.434952,
      2,
      0,
      NULL,
      1,
      1.477251,
      1.707852,
      NULL,
      3,
      0.693047,
      2,
      0,
      1,
      0,
      1.428014,
      2,
      0,
      1,
      3.146661,
      0,
      1.480647,
      NULL,
      0,
      1,
      3,
      3.752324,
      NULL,
      1.823848,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      6,
      0,
      0,
      NULL,
      0,
      1.394294,
      3,
      2,
      1.095435,
      0.683242,
      0.587270,
      1,
      1,
      0.910433,
      2.709795,
      1,
      2,
      NULL,
      0.762393,
      0,
      0,
      1.647198,
      6.508200,
      NULL,
      2,
      0.190513,
      0,
      NULL,
      NULL,
      1.180670,
      NULL,
      NULL,
      0,
      0.639942,
      2.863523,
      1,
      NULL,
      1.021367,
      0,
      1,
      1.274332,
      1,
      1,
      2,
      0,
      1,
      0.594042,
      1,
      1.637873,
      0.231882,
      0,
      NULL,
      0,
      5.297764,
      0,
      1,
      1.502553,
      1,
      NULL,
      0,
      4.622013,
      2.059711,
      NULL,
      NULL,
      1.389037,
      NULL,
      NULL,
      1.597646,
      0,
      1,
      4.064671,
      5,
      4.574236,
      6,
      NULL,
      5.980044,
      9.560233,
      NULL,
      1.486659,
      9.301836,
      2,
      1.953532,
      1,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.723615,
      0,
      NULL,
      0,
      1,
      2,
      0.493884,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.769201,
      NULL,
      5,
      NULL,
      1.184090,
      1.946219,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.692774,
      5,
      NULL,
      0.630475,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.786914,
      1,
      1.779865,
      NULL,
      1,
      2,
      NULL,
      1,
      NULL,
      0.121504,
      1,
      NULL,
      1,
      NULL,
      0.620318,
      0,
      0,
      0,
      1.515637,
      0.882559,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.543815,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      '23341',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


