set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8726488';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-11-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '1',
      NULL,
      NULL,
      '4214341',
      16,
      NULL,
      3,
      1,
      '323001',
      3.921147,
      ' 5-23-1990',
      9.141107,
      NULL,
      1.868496,
      NULL,
      NULL,
      2.639239,
      1,
      1.839833,
      NULL,
      NULL,
      1,
      0,
      0.152036,
      0.265251,
      4,
      1.809262,
      1,
      0.847489,
      1,
      3,
      0.244612,
      0,
      0.962987,
      0.846979,
      1.833936,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      4,
      NULL,
      3,
      NULL,
      1,
      NULL,
      0,
      3,
      0,
      3,
      1.519499,
      0.248800,
      1,
      3,
      NULL,
      1.346361,
      3.178174,
      0.544741,
      NULL,
      0.696554,
      1.745049,
      3.584559,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      0.634449,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      4,
      0,
      1.351728,
      0,
      0.472639,
      1,
      NULL,
      0.797467,
      0,
      NULL,
      0,
      1,
      0.115411,
      NULL,
      0,
      NULL,
      0,
      1,
      0.081063,
      0,
      0.086148,
      0,
      0,
      1,
      0.935184,
      NULL,
      1.867856,
      3.141196,
      3,
      0,
      1,
      NULL,
      0,
      NULL,
      0.587327,
      NULL,
      5.632053,
      5,
      2,
      7.730947,
      5,
      NULL,
      1.763176,
      1.191790,
      3.616208,
      NULL,
      0,
      0.341660,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.670697,
      1,
      0,
      NULL,
      1,
      4,
      0.268510,
      0.830917,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.219201,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.765700,
      NULL,
      2,
      0,
      1.813559,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.938463,
      3.591112,
      1.493963,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.249069,
      1.002098,
      0.443093,
      NULL,
      1,
      2,
      1,
      NULL,
      1,
      1.338550,
      1,
      1,
      0.901894,
      0.337989,
      1,
      1.999250,
      1,
      NULL,
      1,
      1.689021,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      '12210',
      NULL,
      '',
      0.211113,
      '',
      '',
      NULL,
      0,
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


