set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8726488';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-5-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '4',
      NULL,
      NULL,
      '2240313',
      15.089319,
      2,
      NULL,
      3,
      '424222',
      1,
      NULL,
      10,
      NULL,
      0.658612,
      NULL,
      NULL,
      NULL,
      2.416303,
      1.155525,
      NULL,
      NULL,
      0.735552,
      1,
      2,
      1.871446,
      7,
      1,
      1.603208,
      0,
      2.743719,
      1.967218,
      NULL,
      0,
      1,
      0,
      1.196632,
      NULL,
      5,
      1,
      1.306657,
      1,
      0,
      0.515620,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.200768,
      NULL,
      1.161528,
      1,
      0.519081,
      NULL,
      0.844570,
      2.972468,
      2.949606,
      2,
      0.870753,
      0,
      NULL,
      NULL,
      1.502215,
      NULL,
      3,
      1.060019,
      3,
      NULL,
      0,
      NULL,
      4,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      1.558518,
      NULL,
      NULL,
      1,
      0.200636,
      0.696004,
      3,
      0,
      0.178916,
      0,
      0.490358,
      0,
      2.056960,
      1,
      0,
      1,
      1,
      1,
      0,
      0.235074,
      NULL,
      1,
      NULL,
      0.676739,
      1.788829,
      1,
      1.542497,
      0.663231,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      0.327365,
      0,
      5.370996,
      0.091729,
      NULL,
      0,
      2.129554,
      3,
      4,
      1.316909,
      NULL,
      4.310386,
      4,
      2.933578,
      0,
      1.771757,
      4,
      0.650957,
      1.092496,
      NULL,
      NULL,
      1.522329,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.389329,
      1,
      1,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.262191,
      NULL,
      3,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.333885,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.353879,
      0.068410,
      0.841555,
      1.964276,
      0.675654,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.407747,
      1.938030,
      1.402084,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.646658,
      1,
      NULL,
      0.583771,
      3,
      0,
      NULL,
      NULL,
      0.281756,
      NULL,
      0,
      1,
      0.489476,
      1,
      1,
      0,
      0.193411,
      1.772423,
      0.084905,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.770345,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      '13140',
      '',
      '',
      1,
      '',
      NULL,
      '',
      0.751414,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


