set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8726488';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-10-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '4',
      NULL,
      NULL,
      '4343320',
      NULL,
      NULL,
      0.036471,
      NULL,
      '433033',
      1.270026,
      ' 5-13-1988',
      NULL,
      NULL,
      1.915759,
      NULL,
      3,
      0,
      1.951263,
      NULL,
      3,
      NULL,
      1,
      NULL,
      0,
      0.182874,
      1,
      NULL,
      0.049805,
      NULL,
      1,
      1,
      6.949292,
      0.921513,
      1,
      0.552720,
      1,
      0.104837,
      NULL,
      1,
      0,
      1.426895,
      0,
      1.584862,
      NULL,
      NULL,
      1.552198,
      NULL,
      NULL,
      0.244914,
      0,
      0.971032,
      NULL,
      NULL,
      NULL,
      0.339632,
      0.853910,
      0,
      1,
      1.790433,
      0,
      1.591847,
      1,
      NULL,
      0.829243,
      NULL,
      1.993070,
      NULL,
      1.976775,
      1.075557,
      0.920601,
      2,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.826296,
      1.237517,
      0,
      1,
      NULL,
      0.995070,
      0.980195,
      1,
      1.195349,
      0,
      NULL,
      0,
      0,
      1.879158,
      0.327169,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1,
      4.242826,
      1,
      0.346014,
      1.125618,
      1,
      5.702590,
      1.372626,
      1,
      NULL,
      1.218991,
      0,
      1,
      0,
      2,
      2.605849,
      0,
      0.215694,
      2,
      0,
      0,
      5,
      0.554503,
      11.440222,
      3.065188,
      0,
      NULL,
      NULL,
      2.687903,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.167138,
      2,
      0,
      1.892932,
      1.299702,
      1.698847,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.631738,
      NULL,
      NULL,
      NULL,
      NULL,
      0.884225,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.416683,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.129847,
      0.539004,
      NULL,
      NULL,
      NULL,
      0.105095,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.103056,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3.913882,
      0.122913,
      NULL,
      NULL,
      1,
      2.309437,
      1,
      0,
      0.581384,
      0,
      1.850273,
      1,
      0.538061,
      NULL,
      0,
      NULL,
      1.977895,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      '',
      '',
      1,
      '',
      '',
      NULL,
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


