set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8726488';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-10-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '2',
      NULL,
      NULL,
      '4324143',
      3.775787,
      NULL,
      3,
      NULL,
      '221100',
      2,
      '10- 8-1976',
      37.015862,
      NULL,
      NULL,
      NULL,
      0.840662,
      1,
      1.919820,
      0,
      1.411613,
      0.797040,
      0,
      1,
      2,
      0,
      0.402571,
      1,
      1,
      1.689994,
      3,
      1,
      NULL,
      0.168412,
      1,
      0.787633,
      0.711021,
      0.990784,
      3,
      0,
      5,
      1,
      0,
      1.767480,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1.693394,
      1,
      NULL,
      1.531094,
      0,
      3.517423,
      2.229854,
      3.307273,
      1,
      3.576095,
      NULL,
      0.875946,
      3.044789,
      0.324549,
      0.534629,
      1.199290,
      0,
      0,
      0,
      0.773915,
      1.845355,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.261427,
      NULL,
      5.024094,
      NULL,
      0,
      2,
      5.102603,
      1.399954,
      1.631362,
      4,
      0,
      3.988298,
      0.180984,
      4.906211,
      0.340812,
      NULL,
      0.631664,
      1,
      1,
      NULL,
      0,
      3.984732,
      0,
      5.019991,
      2.806053,
      NULL,
      5.531453,
      0,
      1.821305,
      2.746087,
      3.555422,
      5,
      0,
      0,
      4,
      5.937672,
      1,
      NULL,
      5.235204,
      5,
      NULL,
      1.353120,
      0,
      0,
      0,
      NULL,
      0.032962,
      0,
      1,
      NULL,
      1.107328,
      3.402418,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.716122,
      1.896808,
      1,
      1,
      1,
      NULL,
      1.397270,
      1.753230,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.692353,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      0.012021,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.825846,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.831784,
      NULL,
      NULL,
      1,
      2.107512,
      3.890344,
      0.195771,
      1.180409,
      0,
      1.665066,
      1.596958,
      1.435602,
      NULL,
      0.366739,
      1,
      1.238726,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.157690,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.836872,
      '40331',
      '',
      '',
      1.269225,
      '',
      NULL,
      NULL,
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


