set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8726488';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-5-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '3',
      NULL,
      NULL,
      '4123200',
      NULL,
      4,
      NULL,
      1,
      '432410',
      3,
      ' 6-21-1986',
      6.292749,
      NULL,
      1,
      NULL,
      NULL,
      0.599246,
      1.053650,
      1,
      1,
      2.581292,
      0,
      1.946655,
      1,
      0,
      2,
      1.146499,
      1,
      NULL,
      0,
      1,
      NULL,
      0.459853,
      0.051803,
      1.359172,
      1,
      0.363162,
      5,
      NULL,
      2.251435,
      0,
      1,
      0,
      NULL,
      NULL,
      0.066666,
      NULL,
      NULL,
      5.957305,
      0,
      0.556757,
      3.751470,
      1,
      0.611008,
      0.067825,
      0.206590,
      NULL,
      NULL,
      1,
      1,
      1.866188,
      1,
      1,
      0,
      NULL,
      1.231214,
      0,
      0.010049,
      NULL,
      1,
      4.009504,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.965589,
      1.144341,
      1.634431,
      NULL,
      0.469259,
      0.419801,
      1.102558,
      0.681559,
      0,
      1.030306,
      NULL,
      NULL,
      0.456763,
      1.279411,
      1.052981,
      0.368803,
      0,
      1.627240,
      NULL,
      1,
      4.056584,
      0,
      1,
      4.182360,
      0,
      NULL,
      1,
      0,
      NULL,
      1.327119,
      1.950751,
      0.276625,
      1,
      0,
      1.929576,
      0.734832,
      3.713290,
      0.306528,
      1.381132,
      2.991936,
      0,
      1.205079,
      5,
      NULL,
      3,
      NULL,
      4.589394,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      1,
      NULL,
      1.261570,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.865072,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      0,
      0,
      0.560434,
      NULL,
      NULL,
      NULL,
      1.220010,
      0.141809,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.100710,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1.560779,
      1,
      NULL,
      1.329040,
      NULL,
      NULL,
      NULL,
      1.329910,
      0.357889,
      1,
      1.944453,
      NULL,
      NULL,
      0.144248,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '04113',
      '',
      '',
      1,
      NULL,
      '',
      '',
      1.614270,
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


